# coding=utf-8
from __future__ import unicode_literals

from sandbox import sdk2
from sandbox.projects.metrika.utils.parameters import choices
from sandbox.projects.sdc.common.utils import run_command
from sandbox.projects.sdc.simulator.SdcSimulatorRunProgram import (
    SdcSimulatorRunProgram,
    CommonParameters, SECRET_ID,
)


class SdcSimulatorDumpToYt(SdcSimulatorRunProgram):
    class Parameters(CommonParameters):
        with sdk2.parameters.Group('Script parameters') as script_parameters:
            prefix = sdk2.parameters.String('Simulator DB prefix', choices=choices(['testing', 'prod']), required=True)

    @property
    def program(self):
        host = 'vla-h9t3waq2xtmd1zul.db.yandex.net,sas-wwcruh5wksaihj3u.db.yandex.net,man-ycrw4gdwhf56bgbk.db.yandex.net'
        port = 6432
        if self.Parameters.prefix == 'testing':
            dbname = 'simstate'
            user = 'simstate'
        elif self.Parameters.prefix == 'prod':
            dbname = 'simstate-prod'
            user = 'simstate-prod'

        return (
            'python3 -m simulator.backend.simdb.simstate_client --host {host} --port {port} '
            '--dbname {dbname} --prefix {prefix} --user {user} --password-env SIMDB_PASSWORD dump-to-yt'.format(
                host=host, port=port,
                dbname=dbname, prefix=self.Parameters.prefix,
                user=user,
            )
        )

    @property
    def env_vars(self):
        if self.Parameters.prefix == 'testing':
            password_key = 'SIMULATOR_DB_PASSWORD'
        elif self.Parameters.prefix == 'prod':
            password_key = 'SIMULATOR_DB_PASSWORD_PROD'

        return {
            'SIMDB_PASSWORD': '{}#{}'.format(SECRET_ID, password_key),
        }

    def pre_run(self):
        run_command(
            self, './d --run "mkdir ~/.postgresql && wget https://crls.yandex.net/allCAs.pem -O ~/.postgresql/root.crt"',
            cwd=self.sdc_root.as_posix(), logger='crt'
        )
