# coding=utf-8
from __future__ import unicode_literals

from sandbox import sdk2
from sandbox.projects.metrika.utils.parameters import choices, RegexpString
from sandbox.projects.sdc.simulator.SdcSimulatorRunProgram import (
    SdcSimulatorRunProgram,
    CommonParameters,
)
from sandbox.projects.sdc.simulator.utils import SECRET_ID


STABLE_COMMIT = 'a0c75182e901e315a5d0a77c5d59261176e21f9f'


class SdcSimulatorIcTasksStats(SdcSimulatorRunProgram):
    STABLE_COMMIT = STABLE_COMMIT

    class Requirements(SdcSimulatorRunProgram.Requirements):
        cores = 8
        ram = 1024

    class Parameters(CommonParameters):
        use_stable = sdk2.parameters.Bool('Use stable program commit', default=True, description=STABLE_COMMIT)
        with use_stable.value[False]:
            binaries_branch_or_commit = sdk2.parameters.String('Binaries branch or commit hash', default='trunk')

        with sdk2.parameters.Group('Script parameters') as script_parameters:
            env = sdk2.parameters.String('Env', required=True, choices=choices(['prod', 'testing']), default='testing')
            from_date = RegexpString('From date', regexp=r'\d{4}-\d{2]-\d{2}', description='YYYY-MM-DD')

    @property
    def program(self):
        program = (
            'python3 -m simulator.devops.ic_tasks_stats'
            ' --env {env}'
        ).format(
            env=self.Parameters.env,
        )
        if self.Parameters.from_date:
            program += ' --from-date {}'.format(self.Parameters.from_date)
        return program

    @property
    def env_vars(self):
        env_vars = {
            'T__SECRET__ISOLATE_CLOUD_TOKEN': '{}#ISOLATE_CLOUD_TOKEN'.format(SECRET_ID),
        }
        return env_vars
