import re

import requests

from sandbox.projects.common.decorators import retries

SECRET_ID = 'sec-01e47j727mj21xbag7hq8h1rt5'


def get_simulator_api(simulator_api):
    if not simulator_api:
        return 'https://simulator.sdc.yandex-team.ru'
    elif simulator_api in {'prod', 'production'}:
        return 'https://simulator.sdc.yandex-team.ru'
    elif simulator_api in {'test', 'testing'}:
        return 'https://simulator-testing.sdc.yandex-team.ru'
    else:
        return simulator_api.rstrip('/')


def get_ic_api(ic_api):
    if not ic_api:
        return 'https://isolate-cloud.sdc.yandex-team.ru'
    elif ic_api in {'prod', 'production'}:
        return 'https://isolate-cloud.sdc.yandex-team.ru'
    elif ic_api in {'test', 'testing'}:
        return 'https://isolate-cloud-testing.sdc.yandex-team.ru'
    else:
        return ic_api.rstrip('/')


def get_simulator_api_from_ic_api(ic_api):
    if ic_api == 'https://isolate-cloud.sdc.yandex-team.ru':
        return 'https://simulator.sdc.yandex-team.ru'
    elif ic_api == 'https://isolate-cloud-testing.sdc.yandex-team.ru':
        return 'https://simulator-testing.sdc.yandex-team.ru'


def get_binaries_url(commit):
    return 'https://s3.mds.yandex.net/sdc-ci-data/binaries-tgz/release/{}'.format(commit)


@retries(3)
def binaries_are_ready(commit):
    return requests.head(get_binaries_url(commit)).status_code == 200


def is_branch(commit):
    return bool(commit and not re.match(r'^[0-9a-f]{40}$', commit))
