import json

from sandbox.projects.common.deploy_jupiter import build_replicamap, REPLICAMAP_FILENAME
from sandbox.projects.resource_types import REPLICAMAP

from sandbox.sdk2 import Task
from sandbox.sdk2.parameters import String


class BuildReplicamapCommon(Task):
    class Parameters(Task.Parameters):
        gencfg_tag = String(
            'Gencfg topology tag',
            required=True,
        )
        group_prefix = String(
            'Gencfg topology group prefix',
            required=True,
        )
        timestamp = String(
            'DB generation (unix timestamp)',
            required=False,
        )
        yt_state = String(
            'Yt state to build',
            required=True,
        )

    def on_execute(self):
        replicamap = build_replicamap(
            self.Parameters.group_prefix,
            self.Parameters.gencfg_tag,
            self.Parameters.yt_state,
            self.Parameters.timestamp or _gen_timestamp(),
            self.id
        )

        with open(REPLICAMAP_FILENAME, 'w') as f:
            f.write(json.dumps(replicamap, indent=4))

        REPLICAMAP(
            self,
            'Replicamap for {0}, yt state: {1}'.format(self.Parameters.group_prefix, self.Parameters.yt_state),
            REPLICAMAP_FILENAME,
        )


def _gen_timestamp():
    import time
    return str(int(time.time()))
