# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as subprocess

import json
import tempfile


class WithRtmrRequestParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group('Rtmr requests parameters') as rtmr_request_parameters:
        rtmr_mirror = sdk2.parameters.String(
            'Rtmr mirror',
            required=True,
            default='rtmr-man4.search.yandex.net:8080',
        )
        rtmr_client = sdk2.parameters.String(
            'Rtmr client',
            required=True,
            default='personalization',
        )
        rtmr_max_time_back = sdk2.parameters.Integer(
            'Rtmr maxtimeback request parameter (in seconds)',
            required=True,
            default=60 * 60,
        )
        rtmr_max_response_size = sdk2.parameters.Integer(
            'Rtmr mrs request parameter (in bytes)',
            required=True,
            default=2 ** 20,
        )
        rtmr_max_records = sdk2.parameters.Integer(
            'Rtmr maxrecords request parameter',
            required=True,
            default=1000,
        )


def get_input_temp_file_holder(inpt):
    temp_file_holder = tempfile.NamedTemporaryFile()
    with open(temp_file_holder.name, 'w') as temp_file:
        temp_file.write(inpt)
    return temp_file_holder


class RtmrFetcher(object):
    def __init__(self, rtmr_fetch_tool_file_path, rtmr_request_parameters):
        self.rtmr_fetch_tool_file_path = rtmr_fetch_tool_file_path
        self.rtmr_request_parameters = rtmr_request_parameters

    def parse_rtmr_output(self, rtmr_output):
        result = []
        for rtmr_key_output in rtmr_output.strip().split('\n'):
            if rtmr_key_output == 'null':
                continue
            rtmr_key_output_json = json.loads(rtmr_key_output)
            for entry in rtmr_key_output_json['Entries']:
                result.append((entry['Key'], entry['SubKey'], entry['Value']))
        return result

    def fetch_keys_file(self, keys_file_path, table, stderr=None):
        rtmr_fetch_tool_command = [
            self.rtmr_fetch_tool_file_path,
            '--rtmr', self.rtmr_request_parameters.rtmr_mirror,
            '--view', 'json',
            '--table', table,
            '--client', self.rtmr_request_parameters.rtmr_client,
            '--keys', keys_file_path,
            '--maxtimeback', str(self.rtmr_request_parameters.rtmr_max_time_back),
            '--mrs', str(self.rtmr_request_parameters.rtmr_max_response_size),
            '--maxrecords', str(self.rtmr_request_parameters.rtmr_max_records),
        ]
        return self.parse_rtmr_output(
            subprocess.check_output(rtmr_fetch_tool_command, stderr=stderr)
        )

    def fetch_keys(self, keys, table, stderr=None):
        keys_file_content = '\n'.join(keys) + '\n'
        keys_file_holder = get_input_temp_file_holder(keys_file_content)
        return self.fetch_keys_file(keys_file_holder.name, table, stderr)
