# -*- coding: utf-8 -*-

from sandbox import sdk2


SEARCH_PERS_TEAM = [
    'skorodumov-s',
    'x33nu',
    'mikhail-ark',
    'sevenzik',
]


class SearchPersMonitoringTools(sdk2.Resource):
    releasable = True
    releasers = SEARCH_PERS_TEAM
    revision = sdk2.parameters.Integer('Arcadia revision')


class SearchPersUserIds(sdk2.Resource):
    releasable = True
    releasers = SEARCH_PERS_TEAM


class SearchPersUserSessions(sdk2.Resource):
    releasable = True
    releasers = SEARCH_PERS_TEAM


class SearchPersUserProfiles(sdk2.Resource):
    releasable = True
    releasers = SEARCH_PERS_TEAM


class TurboRapidClicksParserPackage(sdk2.Resource):
    auto_backup = True
    releasable = True
    ttl = 100
    releasers = ['SEARCH-PERS', 'RELEASE_MACHINE', 'robot-search-bigb', 'robot-srch-releaser']


class SpylogParserFilesPackage(sdk2.Resource):
    auto_backup = True
    releasable = True
    ttl = 100
    releasers = ['SEARCH-PERS', 'RELEASE_MACHINE', 'robot-search-bigb', 'robot-srch-releaser']


class SpylogParserExecutable(sdk2.Resource):
    auto_backup = True
    releasable = True
    executable = True
    ttl = 100
    releasers = ['SEARCH-PERS', 'RELEASE_MACHINE', 'robot-search-bigb', 'robot-srch-releaser']
    arcadia_build_path = 'quality/personalization/big_rt/spylog/parser'


class AggregatorFilesPackage(sdk2.Resource):
    auto_backup = True
    releasable = True
    ttl = 100
    releasers = ['SEARCH-PERS', 'RELEASE_MACHINE', 'robot-search-bigb', 'robot-srch-releaser']


class AggregatorExecutable(sdk2.Resource):
    auto_backup = True
    releasable = True
    executable = True
    ttl = 100
    releasers = ['SEARCH-PERS', 'RELEASE_MACHINE', 'robot-search-bigb', 'robot-srch-releaser']
    arcadia_build_path = 'quality/personalization/big_rt/aggregator'


class AggregatorVcdiffPackage(sdk2.Resource):
    auto_backup = True
    releasable = True
    ttl = 100
    releasers = ['SEARCH-PERS', 'RELEASE_MACHINE', 'robot-search-bigb', 'robot-srch-releaser']


class AggregatorVcdiffPackageTurbo(sdk2.Resource):
    # clone of AGGREGATOR_VCDIFF_PACKAGE in order to fix RTCSUPPORT-13338
    auto_backup = True
    releasable = True
    ttl = 100
    releasers = ['SEARCH-PERS', 'RELEASE_MACHINE', 'robot-search-bigb', 'robot-srch-releaser']


class AggregatorVcdiffPackageWatchLog(sdk2.Resource):
    # clone of AGGREGATOR_VCDIFF_PACKAGE in order to fix RTCSUPPORT-13338
    auto_backup = True
    releasable = True
    ttl = 100
    releasers = ['SEARCH-PERS', 'RELEASE_MACHINE', 'robot-search-bigb', 'robot-srch-releaser']


class AggregatorPackageSpylog(sdk2.Resource):
    # clone of AGGREGATOR_PACKAGE in order to fix RTCSUPPORT-13338
    auto_backup = True
    releasable = True
    ttl = 100
    releasers = ['SEARCH-PERS', 'RELEASE_MACHINE', 'robot-search-bigb', 'robot-srch-releaser']


class AggregatorPackageWatchLog(sdk2.Resource):
    # clone of AGGREGATOR_PACKAGE in order to fix RTCSUPPORT-13338
    auto_backup = True
    releasable = True
    ttl = 100
    releasers = ['SEARCH-PERS', 'RELEASE_MACHINE', 'robot-search-bigb', 'robot-srch-releaser']


class DyntableHttpProxyExecutable(sdk2.Resource):
    auto_backup = True
    releasable = True
    executable = True
    ttl = 100
    releasers = ['SEARCH-PERS', 'RELEASE_MACHINE', 'robot-search-bigb', 'robot-srch-releaser']
    arcadia_build_path = 'quality/personalization/big_rt/dynamic_table_http_proxy'


class DyntableHttpProxyExecutablePackage(sdk2.Resource):
    auto_backup = True
    releasable = True
    ttl = 100
    releasers = ['SEARCH-PERS', 'RELEASE_MACHINE', 'robot-search-bigb', 'robot-srch-releaser']


class DyntableHttpProxyFilesPackage(sdk2.Resource):
    auto_backup = True
    releasable = True
    ttl = 100
    releasers = ['SEARCH-PERS', 'RELEASE_MACHINE', 'robot-search-bigb', 'robot-srch-releaser']


class UserHistoryPackage(sdk2.Resource):
    auto_backup = True
    releasable = True
    ttl = 100
    releasers = ['SEARCH-PERS', 'RELEASE_MACHINE', 'robot-search-bigb', 'robot-srch-releaser']


class WatchLogResharderFilesPackage(sdk2.Resource):
    auto_backup = True
    releasable = True
    ttl = 100
    releasers = ['SEARCH-PERS', 'RELEASE_MACHINE', 'robot-search-bigb', 'robot-srch-releaser']


class WatchLogParserFilesPackage(sdk2.Resource):
    auto_backup = True
    releasable = True
    ttl = 100
    releasers = ['SEARCH-PERS', 'RELEASE_MACHINE', 'robot-search-bigb', 'robot-srch-releaser']
