from sandbox import common, sdk2
from sandbox.projects.sandbox.resources import LXC_CONTAINER
from sandbox.common.types import (
    resource as ctr,
    task as ctt,
)


class LightPageReviserContainer(sdk2.parameters.Container):
    """
    Container with chrome/chromium/lighthouse
    """
    @common.utils.classproperty
    def default_value(cls):
        try:
            return sdk2.task.Task.server.resource.read(
                type=LXC_CONTAINER,
                state=ctr.State.READY,
                attrs={
                    'custom': 'lighthouse',
                    'released': ctt.ReleaseStatus.STABLE
                },
                limit=1,
            )['items'][0]['id']
        except LookupError:
            return None
