#!/usr/bin/env bash

set -o xtrace
set -o errexit

export DEBIAN_FRONTEND=noninteractive

sudo apt-get update
sudo apt-get install --yes \
	apt-transport-https \
	ca-certificates \
	curl \
	software-properties-common \
	gnupg \
	lsb-release

curl -fsSL https://download.docker.com/linux/ubuntu/gpg | sudo gpg --dearmor -o /usr/share/keyrings/docker-archive-keyring.gpg

echo \
  "deb [arch=amd64 signed-by=/usr/share/keyrings/docker-archive-keyring.gpg] https://download.docker.com/linux/ubuntu \
  $(lsb_release -cs) stable" | sudo tee /etc/apt/sources.list.d/docker.list > /dev/null

sudo apt-get update
sudo apt-get install --yes docker-ce docker-ce-cli containerd.io

default_gw_if=$(ip -6 r s | grep -m 1 ^default | awk '{print $5}')

ip -6 r s
ip a

sudo service docker stop
sudo ip link del docker0
sudo rm -rf /var/lib/docker

sudo cat > /etc/docker/daemon.json <<-EOF
{
    "iptables": false,
    "ip-forward": false,
    "ipv6": true,
    "dns": [
        "2a02:6b8:0:3400::1023",
        "2a02:6b8:0:3400::5005"
    ],
    "fixed-cidr": "",
    "fixed-cidr-v6": "fd00::/8"
}
EOF

sudo cat > /etc/default/docker <<-EOF
DOCKER_OPTS="--ipv6 --fixed-cidr-v6 fd00::/8 --dns 2a02:6b8:0:3400::1023"
EOF

sudo gpasswd -a $USER docker
sudo service docker start
sudo service docker status

ip -6 r s
ip a

sudo ip6tables -t nat -A POSTROUTING -o ${default_gw_if} -j MASQUERADE
sudo sysctl -w net.ipv6.conf.all.forwarding=1

docker info
docker run -i --rm ubuntu:14.04 ifconfig eth0
docker run -i --rm ubuntu:14.04 ping6 github.com -c4
