#!/usr/bin/env node
'use strict';
const execa = require('execa');
const bin = require('.');

const input = process.argv.slice(2);

bin.findExisting()
    .catch(function(err) {
        if (err.code === 0) {
            // Skip any child errors
            log.error(err.message);
        }
        process.exit(1);
    })
    .then(function(path) {
        execa(bin.path(), input, { stdio: 'inherit' }).catch(err => {
            if (err.code === 0) {
                // Skip any child errors
                log.error(err.message);
            }
            process.exit(1);
        });
    });
