'use strict';
const path = require('path');
const BinWrapper = require('bin-wrapper');
const revision = require('../package.json').version;
require('./fix-ca');

const dest = {
    darwin: 'osx___tool__',
    linux: 'nix___tool__',
    win32: 'win___tool__.exe'
};

const url = 'https://tools.sec.yandex-team.ru/api/v1/release';
const bin = {
    darwin: `${url}/__tool__/darwin/${revision}/${dest.darwin}`,
    linux: `${url}/__tool__/linux/${revision}/${dest.linux}`,
    win32: `${url}/__tool__/windows/${revision}/${dest.win32}`
};

module.exports = new BinWrapper()
    .src(bin[process.platform], 'darwin')
    .src(bin[process.platform], 'linux')
    .src(bin[process.platform], 'win32')
    .dest(path.resolve(__dirname, '../vendor'))
    .use(dest[process.platform]);
