import sys

DST_MAP = {
    'linux': '__tool__',
    'windows': '__tool__.exe',
    'darwin': '__tool__'
}

URI_MAP = {
    'linux': 'https://tools.sec.yandex-team.ru/api/v1/release/__tool__/linux/{revision}/__tool__',
    'windows': 'https://tools.sec.yandex-team.ru/api/v1/release/__tool__/windows/{revision}/__tool__.exe',
    'darwin': 'https://tools.sec.yandex-team.ru/api/v1/release/__tool__/darwin/{revision}/__tool__'
}


def dest(target_platform=None):
    return DST_MAP[target_platform or platform()]


def uri(revision, target_platform=None):
    return URI_MAP[target_platform or platform()].format(revision=revision)


def platform():
    if sys.platform == 'linux' or sys.platform == 'linux2':
        return 'linux'
    elif sys.platform == 'darwin':
        return 'darwin'
    elif sys.platform == 'win32':
        return 'windows'
    else:
        raise Exception('Failed to determine system platform: %s' % platform)
