import os
from setuptools import setup
from setuptools.command.install import install
from __pkg___bin import binary, version

try:
    from urllib.request import urlretrieve
    from email.utils import parseaddr as parse_author
except ImportError as e:
    # Python 2
    from urllib import urlretrieve
    from email.Utils import parseaddr as parse_author

PKG_NAME = '__pkg___bin'
AUTHOR = '__author__'
TARGET_PLATFORM = os.environ.get('TARGET_PLATFORM', None)
DEFAULTS = {
    'repl': {
        'linux': 'manylinux1_x86_64',
        'windows': 'win_amd64',
        'darwin': '.'.join('macosx_{ver}_intel.macosx_{ver}_x86_64'.format(ver=v.replace('.', '_'))
            for v in ['10.11', '10.12', '10.13'])
    },
    'platform': {
        'linux': 'linux',
        'windows': 'windows',
        'darwin': 'darwin'
    }
}

cmdclass = {}


class PostInstallCommand(install, object):
    def run(self):
        install.run(self)
        dest = binary.dest(self._forced_platform())
        dest = os.path.join(self.install_purelib, PKG_NAME, 'vendor', dest)
        print('Download tool to: %s' % dest)
        self.download(dest)

    def download(self, dst):
        download_uri = binary.uri(version.LATEST, self._forced_platform())
        try:
            urlretrieve(download_uri, dst)
        except Exception as e:
            raise Exception('Failed to download tool from url %s: %s' % (download_uri, e))
        os.chmod(dst, 0o755)

    def _forced_platform(self):
        if not TARGET_PLATFORM:
            return None
        return DEFAULTS.get('platform', {}).get(TARGET_PLATFORM, None)


cmdclass['install'] = PostInstallCommand
try:
    from wheel.bdist_wheel import bdist_wheel

    class ForcedWheelTags(bdist_wheel, object):
        def get_tag(self):
            orig_tag = super(ForcedWheelTags, self).get_tag()
            repl = self._forced_repl()
            if not repl:
                return orig_tag

            tag = (orig_tag[0], orig_tag[1], repl)
            print('Switched tag from: "{}" to "{}"'.format('-'.join(orig_tag), '-'.join(tag)))
            return tag

        def _forced_repl(self):
            if not TARGET_PLATFORM:
                return None
            return DEFAULTS.get('repl', {}).get(TARGET_PLATFORM, None)

    cmdclass['bdist_wheel'] = ForcedWheelTags
except ImportError:
    pass


author, author_email = parse_author(AUTHOR)
setup(
    name=PKG_NAME,
    version=version.LATEST,
    description='__tool__ wrapper that makes it seamlessly available as a local dependency',
    author=author,
    author_email=author_email,
    url='https://tools.sec.yandex-team.ru/__tool__',
    entry_points={
        'console_scripts': ['__tool__=%s.main:main' % PKG_NAME],
    },
    packages=[PKG_NAME],
    package_data={PKG_NAME: ['vendor/readme.txt']},
    classifiers=[
        'Environment :: Console',
        'Intended Audience :: Developers',
    ],
    cmdclass=cmdclass,
    )
