from sandbox import sdk2
from sandbox.sdk2 import Resource

# Resource time to live:
LOGS_CORPUS_TTL = 10
INDEX_TTL = 60
CORPUS_TTL = 60
REPORT_EXECUTABLE_TTL = 60
TREASURES_TTL = 360
FIRED_CORPUS_TTL = 360

# Other resources used:
MARKET_REPORT_LITE_DEPENDS = 'MARKET_REPORT_LITE_DEPENDS'
MARKET_REPORT = 'MARKET_REPORT'


class ReportCollectedCorpus(Resource):
    """
    Resulting corpus may be collected from 3 sources:
    + Balancer logs via YQL query
    + Tests via run.py --collect-corpus script
    + Recently fired corpus on previous fuzz runs
    """
    ttl = CORPUS_TTL

    revision = sdk2.parameters.Integer()
    minimized = sdk2.parameters.Bool()

    from_logs = sdk2.parameters.Bool()
    from_tests = sdk2.parameters.Bool()
    from_fuzz_runs = sdk2.parameters.Bool()


class ReportCollectedIndex(Resource):
    """
    Index is collected via run.py --collect-corpus script
    Entire directory is zipped. Contains report config inside.
    """
    ttl = INDEX_TTL

    revision = sdk2.parameters.Integer()


class ReportCollectedLiteIndex(Resource):
    """
    Index that was collected via test_prime.py -s script
    Entire directory is zipped. Contains report config inside.
    """
    ttl = INDEX_TTL

    revision = sdk2.parameters.Integer()


class ReportFuzzExecutable(Resource):
    """
    Report fuzz driver compiled with sanitizer flags
    """
    ttl = REPORT_EXECUTABLE_TTL

    revision = sdk2.parameters.Integer()
    build_type = sdk2.parameters.String()


class ReportFuzzTreasure(Resource):
    """
    Fuzz findings
    """
    ttl = TREASURES_TTL

    revision = sdk2.parameters.Integer()
    findings = sdk2.parameters.String()
    fuzz_runtime = sdk2.parameters.String()
    index_id = sdk2.parameters.Integer()
    corpus_id = sdk2.parameters.Integer()


class ReportFiredCorpus(Resource):
    """
    Interesting corpus items discovered by fuzzer
    """
    ttl = FIRED_CORPUS_TTL

    revision = sdk2.parameters.Integer()
    items_count = sdk2.parameters.Integer()


class CorpusFromLogs(Resource):
    """
    Corpus fetched via YQL query from balancer logs
    """
    ttl = LOGS_CORPUS_TTL
    tag = ['from_db']
