import os
import stat

import sandbox.common.types.resource as ctr
from sandbox import sdk2


def get_last_released_resource(resource_type, attrs={}):
    return resource_type.find(
        attrs=attrs or {},
        state=ctr.State.READY,
        arch="linux"
    ).order(-sdk2.Resource.id).first()


def download_resource(resource):
    return sdk2.ResourceData(resource).path.as_posix()


def chmod_x(path):
    st = os.stat(path)
    os.chmod(path, st.st_mode | stat.S_IEXEC)


class cached_property(object):
    def __init__(self, func):
        self.func = func

    def __get__(self, obj, cls=None):
        if obj is None:
            return self
        val = obj.__dict__[self.func.__name__] = self.func(obj)
        return val
