# coding: utf-8
import os

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess
from sandbox.common.types import client as ctc

from sandbox.projects.security.common import helpers
from sandbox.projects.security.resources import SecurityToolBinary


class SecurityBaseTask(sdk2.Task):
    subtask_binary_path = None

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC | ctc.Tag.MULTISLOT
        disk_space = 1024
        ram = 2048

    class SecurityOptions(object):
        # Download and use binary of this type.
        subtask_resource_type = SecurityToolBinary

        # Additionaly you can filter by attrs.
        subtask_resource_attrs = None

        # Run this command on execution phase.
        # If you want to generate command dynamically you need to override
        # get_cmd method of SecurityBaseTask.
        cmd = None

        # Update common environment with this additional variables.
        # If you want to generate additional environment dynamically you
        # need to override get_additional_env method of SecurityBaseTask.
        additional_env = None

    def on_prepare(self):
        resource = self.get_subtask_resource()
        self.subtask_binary_path = helpers.download_resource(resource)
        helpers.chmod_x(self.subtask_binary_path)

    def on_execute(self):
        with sdk2.helpers.ProcessLog(self, logger="security_subtask") as pl:
            cmd = self.get_cmd(self.subtask_binary_path)
            env = self.get_env()
            subprocess.check_call(cmd, shell=False, stdout=pl.stdout, stderr=pl.stderr, env=env)

    def get_env(self):
        env = os.environ.copy()
        additional_env = self.get_additional_env()
        assert isinstance(additional_env, dict), "Additional environment must be instance of dict"
        env.update(additional_env)
        return env

    def get_subtask_resource(self):
        return helpers.get_last_released_resource(self.SecurityOptions.subtask_resource_type,
                                                  self.SecurityOptions.subtask_resource_attrs)

    def get_cmd(self, binary_path):
        cmd = [binary_path]
        return cmd + [item(self) if callable(item) else item for item in self.SecurityOptions.cmd]

    def get_additional_env(self):
        return self.SecurityOptions.additional_env or {}
