import requests
import yt.wrapper
import urllib
from multiprocessing.pool import ThreadPool as Pool
from sandbox import sdk2
from sqlalchemy.ext.automap import automap_base
from sqlalchemy.orm import Session
from sqlalchemy import create_engine


def list_merge(lstlst):
    all = []
    for lst in lstlst:
        all.extend(lst)
    return all


class Access_Management_Bot():
    def __init__(self, idm_oauth, yt_oauth, deploy_acl_path, nanny_acl_path, mdb_host, mdb_db, mdb_user, mdb_pass, threads=25):
        self.threads = threads
        self.idm_oauth = idm_oauth
        self.yt_token = yt_oauth
        self.deploy_acl_path = deploy_acl_path
        self.nanny_acl_path = nanny_acl_path

        self.mdb_pass = mdb_pass
        self.mdb_host = mdb_host
        self.mdb_user = mdb_user
        self.mdb_db = mdb_db

        Base = automap_base()

        self.port = 6432
        engine = create_engine(
            f"postgresql+psycopg2://{self.mdb_user}:{self.mdb_pass}@{self.mdb_host}:{self.port}/{self.mdb_db}",
            convert_unicode=False)

        Base.prepare(engine, reflect=True)

        self.Rtype = Base.classes.rtype
        self.Access = Base.classes.access
        self.Role = Base.classes.role

        self.db_session = Session(engine)

        self.requests = requests.Session()
        self.requests.headers = {'Authorization': 'OAuth ' + self.idm_oauth}

        self.yt_client = yt.wrapper.YtClient(proxy='hahn', token=yt_oauth)

    def get_urls(self, url_pref, params):
        limit, offset = params.get('limit'), params.get('offset')
        url = f'{url_pref}?{urllib.parse.urlencode(params)}'
        json_resp = self.requests.get(url).json()
        total_count = json_resp['meta']['total_count']
        max_offset = (total_count // limit) * limit
        urls = [url.replace(f'&offset={offset}', f'&offset={i}') for i in range(offset, max_offset, limit)]
        if not urls:
            urls = [url]
        return urls

    def get_ids(self, url):
        json_resp = self.requests.get(url).json()
        return [int(i['role'].split('/')[-2]) for i in json_resp['objects']]

    def get_roles_info(self, url):
        json_resp = self.requests.get(url).json()
        result = {}
        for i in json_resp['objects']:
            id, user, path = i['id'], i['user']['username'], i['node']['value_path']
            result.setdefault(id, (user, path))
        return result

    def get_all_ids(self, subject):
        url_pref = 'https://idm-api.yandex-team.ru/api/frontend/actions/'
        params = {
            'user': 'robot-ironmax',
            'system': 'gideon-analytics',
            'path': '/' + subject + '/',
            'action': 'request',
            'is_active': 'true',
            'limit': 1000,
            'offset': 0
        }
        urls = self.get_urls(url_pref, params)
        with Pool(self.threads) as pool:
            result = pool.map(self.get_ids, urls)
        return list_merge(result)

    def get_all_roles(self):
        url_pref = 'https://idm-api.yandex-team.ru/api/v1/roles/'
        params = {
            'system': 'gideon-analytics',
            'type': 'active',
            'ownership': 'personal',
            'limit': 1000,
            'offset': 0
        }
        urls = self.get_urls(url_pref, params)
        with Pool(self.threads) as pool:
            result = pool.map(self.get_roles_info, urls)
        return result[0]

    def request_role_per_stage(self, user, stage):
        body = {'user': user, 'system': 'gideon-analytics', 'path': '/stage/' + stage + '/', 'silent': 'true'}
        url_pref = 'https://idm-api.yandex-team.ru/api/v1/rolerequests/'
        r = self.requests.post(url_pref, json=body)
        return r.status_code

    def request_role_per_nanny(self, user, nanny_id):
        body = {'user': user, 'system': 'gideon-analytics', 'path': '/nanny_id/' + nanny_id + '/', 'silent': 'true'}
        url_pref = 'https://idm-api.yandex-team.ru/api/v1/rolerequests/'
        r = self.requests.post(url_pref, json=body)
        return r.status_code

    def add_access(self):
        subjects = ['nanny_id', 'stage']
        for subject in subjects:
            yt_acl_path = self.deploy_acl_path if subject == 'stage' else self.nanny_acl_path

            yt_roles = [row for row in self.yt_client.read_table(yt_acl_path)]
            yt_users = [item['user'] for item in yt_roles]
            yt_subjects = [item[subject] for item in yt_roles]
            yt_data = list(zip(yt_users, yt_subjects))

            mdb_subject_id = self.db_session.query(self.Rtype).filter_by(caption=subject).first().id
            mdb_access_list = self.db_session.query(self.Access).filter_by(role_type=mdb_subject_id)

            mdb_users = [i.user for i in mdb_access_list]
            mdb_subjects = [i.subject for i in mdb_access_list]
            mdb_data = list(zip(mdb_users, mdb_subjects))

            to_add_to_acl = list(set(yt_data) - set(mdb_data))
            with Pool(self.threads) as pool:
                if subject == 'nanny_id':
                    pool.starmap(self.request_role_per_nanny, to_add_to_acl)
                if subject == 'stage':
                    pool.starmap(self.request_role_per_stage, to_add_to_acl)

    def run(self):
        self.add_access()


class ACCESS_MANAGEMENT_BOT_TASK(sdk2.Task):

    class Parameters(sdk2.Parameters):
        enable_yav = True
        app_tokens = sdk2.parameters.YavSecret("APP OAuth", default="sec-01fynr8vy3w0cbsx7ag0gbhea0")
        deploy_acl_path = sdk2.parameters.String("ACL на YT", default="//home/infrasec/gideon-analytics/resources/acl-deploy")
        nanny_acl_path = sdk2.parameters.String("ACL на YT", default="//home/infrasec/gideon-analytics/resources/acl-nanny")
        mdb_user = sdk2.parameters.String("MDB user", default="gideon-analytics")
        mdb_host = sdk2.parameters.String("MDB host", default="sas-nx6mej68qoxc3p51.db.yandex.net")
        mdb_db = sdk2.parameters.String("MDB db", default="gideon-analytics")

    def on_execute(self):
        app_tokens = self.Parameters.app_tokens.data()

        mdb_host = self.Parameters.mdb_host
        mdb_db = self.Parameters.mdb_db
        mdb_user = self.Parameters.mdb_user
        mdb_pass = app_tokens['mdb_password']

        idm_oauth = app_tokens['idm_oauth']
        yt_ouath = app_tokens['yt_oauth']

        deploy_acl_path = self.Parameters.deploy_acl_path
        nanny_acl_path = self.Parameters.nanny_acl_path

        bot = Access_Management_Bot(idm_oauth, yt_ouath, deploy_acl_path, nanny_acl_path, mdb_host, mdb_db, mdb_user, mdb_pass)
        bot.run()
