import requests
from yt.wrapper import YtClient
import yt.wrapper as yt
from sandbox import sdk2


class WalleFilter():
    def __init__(self, yt_oauth, walle_oauth):
        self.yt_oauth = yt_oauth
        self.walle_oauth = walle_oauth

        self.requests = requests.Session()
        self.requests.headers.update({'Authorization': f'OAuth {walle_oauth}'})

        self.yt_client = YtClient(proxy="hahn", token=yt_oauth)

    def listmerge(self, lstlst):
        all=[]
        for lst in lstlst:
            all.extend(lst)
        return all

    def get_walley(self, tags=''):
        url = "https://api.wall-e.yandex-team.ru/v1/hosts?cursor={cursor}&fields=name,project&limit=10000&tags={tags}"
        cursor = 0
        response = []
        while True:
            json_response = self.requests.get(url.format(cursor=cursor, tags=tags)).json()
            result = json_response['result']
            # projects = [i['project'] for i in result]
            hosts = [i['name'] for i in result]
            response.append(hosts)
            # response.append(tuple(zip(projects, hosts)))
            if 'next_cursor' not in json_response:
                break
            cursor = json_response['next_cursor']
        # return listmerge(tuple(response))
        return self.listmerge(response)

    def get_tags_by_project(self, project):
        json_response = self.requests.get(f'https://api.wall-e.yandex-team.ru/v1/projects/{project}').json()
        return json_response['tags'] if 'tags' in json_response else []

    def set_approach(self, a, b):
        return list(set(a)-set(b))

    def save_to_yt(self, hosts, path):
        result = []
        schema = [
            {"name": "host", "type": "string"}
        ]
        for host in hosts:
            result.append({'host': host})
        self.yt_client.write_table(
            yt.TablePath(path, schema=schema),
            result,
            format=yt.JsonFormat(attributes={"encode_utf8": False})
        )

    def get_whitelist(self):
        # all_walley = self.get_walley()
        wally_with_rtc = self.get_walley('rtc')
        wally_with_stage_prod = self.get_walley('rtc.stage-production')

        wally_whitelist = list(set(wally_with_rtc) & set(wally_with_stage_prod))
        # wally_blacklist = self.set_approach(all_walley, wally_true)
        return wally_whitelist


class DOM0_RTC_PROD_HOSTS_PARSER_TASK(sdk2.Task):

    class Parameters(sdk2.Parameters):
        enable_yav = True
        app_tokens = sdk2.parameters.YavSecret("APP OAuth", default="sec-01fynr8vy3w0cbsx7ag0gbhea0")
        whitelist_path = sdk2.parameters.String(
            "Путь к таблице на YT, в который будет сохранен белый список продовых хостов из WALLE",
            default="//home/infrasec/gideon-analytics/resources/dom0-rtc-prod-hosts")

    def on_execute(self):
        app_tokens = self.Parameters.app_tokens.data()

        yt_oauth = app_tokens["yt_oauth"]
        walle_oauth = app_tokens["app_oauth"]

        whitelist_path = self.Parameters.whitelist_path

        walle_client = WalleFilter(yt_oauth=yt_oauth, walle_oauth=walle_oauth)
        walle_whitelist = walle_client.get_whitelist()

        walle_client.save_to_yt(walle_whitelist, whitelist_path)
