from sqlalchemy.ext.automap import automap_base
from sqlalchemy.orm import Session
from sqlalchemy import create_engine
import requests
from sandbox import sdk2
from yt.wrapper import YtClient
import yt.wrapper as yt


class MDB_to_YT_Transfer():
    def __init__(self, app_oauth, yt_oauth, mdb_host, mdb_db, mdb_user, mdb_pass):
        self.app_oauth = app_oauth

        self.mdb_host = mdb_host
        self.mdb_db = mdb_db
        self.mdb_user = mdb_user
        self.mdb_pass = mdb_pass

        self.yt_oauth = yt_oauth
        self.yt_client = YtClient(proxy="hahn", token=yt_oauth)

        self.local_logins_cache = {}

        Base = automap_base()

        self.port = 6432
        engine = create_engine(
            f"postgresql+psycopg2://{self.mdb_user}:{self.mdb_pass}@{self.mdb_host}:{self.port}/{self.mdb_db}",
            convert_unicode=False
        )

        Base.prepare(engine, reflect=True)

        self.Rtype = Base.classes.rtype
        self.Access = Base.classes.access
        self.Role = Base.classes.role

        self.db_session = Session(engine)

    def get_uid_by_login(self, login, oauth):
        uid = self.local_logins_cache.get(login)
        if uid is not None:
            return uid
        r = requests.get(f'https://staff-api.yandex-team.ru/v3/persons?_fields=uid&login={login}',
                         headers={'Authorization': 'OAuth ' + oauth})
        try:
            uid = int(r.json()['result'][0]['uid'])
        except:
            uid = 0
        self.local_logins_cache.setdefault(login, uid)
        return uid

    def read_acl(self):
        result_to_upload = []
        r = self.db_session.query(self.Access)
        for i in r:
            res = {'nanny_id': None, 'pod_set_id': None, 'staff': None, 'stage': None, 'user': None, 'user_id': None}
            res[self.db_session.query(self.Rtype).filter_by(id=i.role_type).first().caption] = i.subject
            res['user'] = i.user
            res['user_id'] = self.get_uid_by_login(i.user, self.app_oauth)
            result_to_upload.append(res)
        return result_to_upload

    def upload_acl_to_yt(self, result, path):
        schema = [
            {"name": "abc", "type": "string"},
            {"name": "nanny_id", "type": "string"},
            {"name": "pod_set_id", "type": "string"},
            {"name": "staff", "type": "string"},
            {"name": "stage", "type": "string"},
            {"name": "user", "type": "string"},
            {"name": "user_id", "type": "int64"}
        ]
        self.yt_client.write_table(
            yt.TablePath(path, schema=schema),
            result,
            format=yt.JsonFormat(attributes={"encode_utf8": False})
        )


class IDM_ACL_MDB_TO_YT_TRANSFER_TASK(sdk2.Task):

    class Parameters(sdk2.Parameters):
        enable_yav = True

        app_tokens = sdk2.parameters.YavSecret("APP OAuth", default="sec-01fynr8vy3w0cbsx7ag0gbhea0")

        mdb_host = sdk2.parameters.String("MDB host", default="sas-nx6mej68qoxc3p51.db.yandex.net")
        mdb_user = sdk2.parameters.String("MDB user", default="gideon-analytics")
        mdb_db = sdk2.parameters.String("MDB db", default="gideon-analytics")

        acl_path = sdk2.parameters.String("Путь к таблице на YT, в который будет сохранен ACL из MDB", default="//home/infrasec/gideon-analytics/resources/acl-idm")

    def on_execute(self):
        acl_path = self.Parameters.acl_path

        app_tokens = self.Parameters.app_tokens.data()
        mdb_pass = app_tokens['mdb_password']
        app_oauth = app_tokens['app_oauth']
        yt_oauth = app_tokens['yt_oauth']

        mdb_user = self.Parameters.mdb_user
        mdb_host = self.Parameters.mdb_host
        mdb_db = self.Parameters.mdb_db

        trf_client = MDB_to_YT_Transfer(app_oauth, yt_oauth, mdb_host, mdb_db, mdb_user, mdb_pass)
        acl = trf_client.read_acl()
        trf_client.upload_acl_to_yt(acl, acl_path)
