from yt.wrapper import YtClient
from sqlalchemy.ext.automap import automap_base
from sqlalchemy.orm import Session
from sqlalchemy import create_engine
from sandbox import sdk2
from multiprocessing.pool import ThreadPool as Pool
import itertools


class YT_to_MDB_Transfer():

    def __init__(self, yt_oauth, ga_yt_path, mdb_host, mdb_db, mdb_user, mdb_pass):
        self.yt_token = yt_oauth
        self.mdb_pass = mdb_pass
        self.mdb_host = mdb_host
        self.mdb_user = mdb_user
        self.mdb_db = mdb_db
        self.ga_yt_path = ga_yt_path

        self.yt_client = YtClient(proxy="hahn", token=self.yt_token)

        self.Base = automap_base()

        self.username = self.mdb_user
        self.hostname = self.mdb_host
        self.password = self.mdb_pass
        self.port = 6432
        self.db_name = self.mdb_db
        engine = create_engine(
            f"postgresql+psycopg2://{self.username}:{self.password}@{self.hostname}:{self.port}/{self.db_name}",
            convert_unicode=False)

        self.Base.prepare(engine, reflect=True)

        self.Rtype = self.Base.classes.rtype
        self.Access = self.Base.classes.access
        self.Role = self.Base.classes.role

        self.db_session = Session(engine)

    def add_role_to_base(self, role_name, role_id):
        if role_name is None:
            return
        r = self.Role(caption=role_name, type=role_id)
        self.db_session.add(r)

    def transfer(self):
        subject_captions = [subject.caption for subject in self.db_session.query(self.Rtype).all()]
        subject_ids = [subject.id for subject in self.db_session.query(self.Rtype).all()]
        rows = self.yt_client.read_table(self.ga_yt_path)

        for subject_caption, subject_id in list(zip(subject_captions, subject_ids)):
            target = subject_caption
            if target == 'staff':
                target = 'staff_short'
            mdb_current_values = [role.caption for role in self.db_session.query(self.Role).filter_by(type=subject_id)]
            subject_values = list(set([row[target] for row in rows]) - set(mdb_current_values))
            to_add = list(zip(subject_values, itertools.repeat(subject_id)))
            with Pool(25) as pool:
                pool.starmap(self.add_role_to_base, to_add)
            self.db_session.commit()


class IDM_SUBJ_YT_TO_MDB_TRANSFER_TASK(sdk2.Task):

    class Parameters(sdk2.Parameters):
        enable_yav = True

        app_tokens = sdk2.parameters.YavSecret("APP OAuth", default="sec-01fynr8vy3w0cbsx7ag0gbhea0")

        mdb_host = sdk2.parameters.String("MDB host", default="sas-nx6mej68qoxc3p51.db.yandex.net")
        mdb_user = sdk2.parameters.String("MDB user", default="gideon-analytics")
        mdb_db = sdk2.parameters.String("MDB db", default="gideon-analytics")

        ga_yt_path = sdk2.parameters.String(
            "Путь к таблице на YT, откуда будут браться subject'ы для заливки в MDB",
            default="//home/infrasec/gideon-analytics/1d/gideon-analytics"
        )

    def on_execute(self):
        app_tokens = self.Parameters.app_tokens.data()
        mdb_pass = app_tokens['mdb_password']
        yt_oauth = app_tokens['yt_oauth']

        mdb_user = self.Parameters.mdb_user
        mdb_host = self.Parameters.mdb_host
        mdb_db = self.Parameters.mdb_db

        ga_yt_path = self.Parameters.ga_yt_path

        trf_client = YT_to_MDB_Transfer(yt_oauth, ga_yt_path, mdb_host, mdb_db, mdb_user, mdb_pass)
        trf_client.transfer()
