import os
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.common import apihelpers
from sandbox.projects.security.sec_check_quasar_image.common.config import GET_UBIDUMP_RESOURCE_ID
from sandbox.projects.security.sec_check_quasar_image.common.utils import cached_property
from sandbox.projects.security.sec_check_quasar_image.platforms import SecCheckBasePlatformImage
from sandbox.projects.quasar.resource_types import QuasarYandexminiOTAImage


class SecCheckYandexminiOtaImage(SecCheckBasePlatformImage):

    platform = "YANDEXMINI_OTA_IMAGE"

    # class Parameters(SecCheckBasePlatformImage.Parameters):
    #     privileged = True

    @cached_property
    def ubidump(self):
        """Steps:
        1. prepare ubidump requirements;
        2. prepare ubidump.
        """

        resource = sdk2.Resource[GET_UBIDUMP_RESOURCE_ID()]
        if not resource:
            raise Exception("Resource for ubidump tool not found.")

        resource_data = sdk2.ResourceData(resource)
        ubidump_resource_path = str(resource_data.path)

        ubidump_dir = self.temp_dir + "/ubidump"
        os.makedirs(ubidump_dir)
        with sdk2.helpers.ProcessLog(self, logger="ubidump") as pl:
            cmd = " ".join(["tar", "-C", ubidump_dir, "-xvf", ubidump_resource_path])
            sp.check_call(cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT)
        return ubidump_dir + "/ubidump/ubidump.py"

    def _get_image_resource(self):
        """Find last ota_image."""

        ota_image_resource = apihelpers.get_last_resource_with_attribute(
            QuasarYandexminiOTAImage, attribute_name='buildtype', attribute_value='release'
        )
        return ota_image_resource

    def _unpack_image(self):
        """Unzip and convert from sparse Android image to ext4 image."""

        with sdk2.helpers.ProcessLog(self, logger="_unpack_image") as pl:
            no_ext_ota_image = self.ota_image[:-1 * len(".zip")]
            xz_ota_image = no_ext_ota_image + ".xz"
            tar_ota_image = no_ext_ota_image + ".tar"
            zip_ota_image = self.ota_image

            extracted_folder = self.temp_dir + "/extracted"
            rootfs_ubifs = self.temp_dir + "/extracted/rootfs.ubifs"
            rootfs_dir = self.temp_dir + "/rootfs_dir"
            self.rootfs_dir = rootfs_dir + "/raw"

            os.makedirs(extracted_folder)
            # os.makedirs(self.rootfs_dir)

            cmd = "mv {} {}".format(zip_ota_image, xz_ota_image)
            sp.check_call(cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT)

            cmd = "xz -d {}".format(xz_ota_image)
            sp.check_call(cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT)

            cmd = "mv {} {}".format(no_ext_ota_image, tar_ota_image)
            sp.check_call(cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT)

            cmd = "tar -C {} -xvf {}".format(extracted_folder, tar_ota_image)
            sp.check_call(cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT)

            cmd = "cd {} && cpio -idv < yandex_io_ota_enc.swu".format(extracted_folder)
            sp.Popen(cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()

            cmd = "cd {} && cpio -idv < yandex_io_ota.swu".format(extracted_folder)
            sp.Popen(cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()

            cmd = ["python", self.ubidump, "-s", rootfs_dir, rootfs_ubifs]
            sp.check_call(cmd, stdout=pl.stdout, stderr=sp.STDOUT)

            if not os.listdir(self.rootfs_dir):
                raise Exception("Unpacked rootfs_dir is empty.")
