import os
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.common import apihelpers
from sandbox.projects.security.sec_check_quasar_image.common.config import GET_SDAT2IMG_RESOURCE_ID
from sandbox.projects.security.sec_check_quasar_image.common.utils import cached_property
from sandbox.projects.security.sec_check_quasar_image.platforms import SecCheckBasePlatformImage
from sandbox.projects.quasar.resource_types import QuasarYandexstationOTAImage


class SecCheckYandexstationOtaImage(SecCheckBasePlatformImage):

    platform = "YANDEXSTAION_OTA_IMAGE"

    # class Parameters(SecCheckBasePlatformImage.Parameters):
    #     privileged = True

    @cached_property
    def sdat2img(self):
        """Prepare project to convert sparse Android image into ext4fs."""

        sdat2img_resource = sdk2.Resource[GET_SDAT2IMG_RESOURCE_ID()]
        sdat2img_resource_data = sdk2.ResourceData(sdat2img_resource)
        return str(sdat2img_resource_data.path / "sdat2img.py")

    def _get_image_resource(self):
        """Find last ota_image."""

        ota_image_resource = apihelpers.get_last_resource_with_attribute(
            QuasarYandexstationOTAImage, attribute_name='buildtype', attribute_value='user'
        )
        return ota_image_resource

    def _unpack_image(self):
        """Unzip and convert from sparse Android image to ext4 image."""

        with sdk2.helpers.ProcessLog(self, logger="_unpack_image") as pl:

            # cmd = "groups"
            # sp.Popen(cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()
            # cmd = "whoami"
            # sp.Popen(cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()
            # cmd = "id"
            # sp.Popen(cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()

            unzipped_dir = self.temp_dir + "/unzipped"
            ext4_image_file = unzipped_dir + "/system.img"
            self.rootfs_dir = unzipped_dir + "/rootfs_dir"

            cmd = " ".join(["unzip", self.ota_image, "-d", unzipped_dir])
            sp.check_call(cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT)

            cmd = "python {} {}/system.transfer.list {}/system.new.dat {}/system.img".format(
                self.sdat2img, unzipped_dir, unzipped_dir, unzipped_dir
            )
            sp.check_call(cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT)

            os.makedirs(self.rootfs_dir)

            # cmd = " ".join(["sudo", "mount", ext4_image_file, self.rootfs_dir])
            cmd = " ".join(["mount", ext4_image_file, self.rootfs_dir])
            sp.check_call(cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT)

            if not os.listdir(self.rootfs_dir):
                raise Exception("Unpacked rootfs_dir is empty.")

    def _cleanup(self):
        """Umount ext4fs."""

        with sdk2.helpers.ProcessLog(self, logger="_cleanup") as pl:
            # cmd = "sudo umount {}".format(self.rootfs_dir)
            cmd = "umount {}".format(self.rootfs_dir)
            sp.Popen(cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()
