import os
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.common import apihelpers
from sandbox.projects.security.sec_check_quasar_image.common.config import GET_UBIDUMP_RESOURCE_ID
from sandbox.projects.security.sec_check_quasar_image.common.utils import cached_property
from .base_platform import SecCheckBasePlatformImage


class SecCheckJblOtaImage(SecCheckBasePlatformImage):
    """ Base class for JBL Music and JBL Portable OTA images. """

    @cached_property
    def ubidump(self):
        """Steps:
        1. prepare ubidump requirements;
        2. prepare ubidump.
        """

        resource = sdk2.Resource[GET_UBIDUMP_RESOURCE_ID()]
        if not resource:
            raise Exception("Resource for ubidump tool not found.")

        resource_data = sdk2.ResourceData(resource)
        ubidump_resource_path = str(resource_data.path)

        ubidump_dir = self.temp_dir + "/ubidump"
        os.makedirs(ubidump_dir)
        with sdk2.helpers.ProcessLog(self, logger="ubidump") as pl:
            cmd = " ".join(["tar", "-C", ubidump_dir, "-xvf", ubidump_resource_path])
            sp.check_call(cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT)
        return ubidump_dir + "/ubidump/ubidump.py"

    def _get_ota_image_resource_type(self):
        # return QuasarJblLinkMusicOTAImage
        raise NotImplementedError()

    def _get_image_resource(self):
        """Find last ota_image."""

        ota_image_resource = apihelpers.get_last_resource_with_attribute(
            self._get_ota_image_resource_type(), attribute_name='buildtype', attribute_value='release'
        )
        return ota_image_resource

    def _unpack_image(self):

        extracted_ota_image_dir = "{}/extracted_ota_image".format(self.temp_dir)
        unzipped_dir = "{}/unzipped".format(self.temp_dir)
        rootfs_ubi_file = unzipped_dir + "/rootfs.ubi"

        # with environments.VirtualEnvironment() as venv:
        #     venv.pip("pip==19.1 setuptools==41.0.1")
        #     venv.pip("python-lzo crcmod")

        with sdk2.helpers.ProcessLog(self, logger="_unpack_image") as pl:

            cmd = "unzip {} -d {}".format(self.ota_image, unzipped_dir)
            sp.Popen(cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()

            # cmd = [venv.executable, self.ubidump, "-s", extracted_ota_image_dir, rootfs_ubi_file]
            cmd = ["python", self.ubidump, "-s", extracted_ota_image_dir, rootfs_ubi_file]
            sp.check_call(cmd, stdout=pl.stdout, stderr=sp.STDOUT)

        rootfs_dir = os.listdir("{}/".format(extracted_ota_image_dir))[0]
        self.rootfs_dir = "{}/{}".format(extracted_ota_image_dir, rootfs_dir)
