# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
import sandbox.sandboxsdk.ssh as ssh

import os
import shutil

from sandbox.projects.serp_wizards import resource_types as serp_wizards_types
import sandbox.projects.release_machine.core.const as rm_const


class UploadTransportRearrangeData(sdk2.Task):
    """
    Publish districts data to SaaS
    """
    class Parameters(sdk2.Task.Parameters):
        cluster = sdk2.parameters.String("YT cluster", default='hahn', required=True)
        hotels_geoids = sdk2.parameters.String("Geoids with hotels table", default='//home/geosearch/mesherin/geoids_with_hotels')
        geoid_to_entity = sdk2.parameters.String("Geoid to entity search id", default='//home/geosearch/mesherin/geoid_to_entity_id')
        rearrange_path = sdk2.parameters.String("Rerrange.dynamic arcadia path", default='arcadia:/arc/trunk/arcadia/search/web/rearrs_upper/rearrange.dynamic/transport')
        data_builder = sdk2.parameters.Resource(
            'Rearrange data builder',
            resource_type=serp_wizards_types.TRANSPORT_REARRANGE_DATA_BUILDER,
            required=False
        )

    def on_execute(self):
        cwd = os.getcwd()

        svn_url = sdk2.svn.Arcadia.svn_url(self.Parameters.rearrange_path)
        has_path = sdk2.svn.Arcadia.check(svn_url)
        if not has_path:
            sdk2.svn.Arcadia.mkdir(svn_url, user='robot-geosearch', message='Initialization of transport dir')

        transport_dir = sdk2.svn.Arcadia.checkout(svn_url, cwd)
        new_data = os.path.join(cwd, 'fresh_transport')

        preparer = str(sdk2.ResourceData(self.Parameters.data_builder).path)
        token = sdk2.Vault.data('mesherin', 'YQL_TOKEN')
        prep_err = os.path.join(str(self.log_path()), 'prepare_transport.err')
        exec_args = [preparer, '--out-dir', new_data, '--token', token]

        hotels_file = os.path.join(new_data, 'geoid_has_hotels.json')
        entities_file = os.path.join(new_data, 'geoid_entity_id.json')
        sp.check_call(exec_args, stderr=open(prep_err, 'w'))

        shutil.copy(hotels_file, transport_dir)
        shutil.copy(entities_file, transport_dir)

        hotels_svn_url = sdk2.svn.Arcadia.append(svn_url, 'geoid_has_hotels.json')
        entities_svn_url = sdk2.svn.Arcadia.append(svn_url, 'geoid_entity_id.json')

        if not sdk2.svn.Arcadia.check(hotels_svn_url):
            sdk2.svn.Svn.add(os.path.join(transport_dir, 'geoid_has_hotels.json'))
        if not sdk2.svn.Arcadia.check(entities_svn_url):
            sdk2.svn.Svn.add(os.path.join(transport_dir, 'geoid_entity_id.json'))

        with ssh.Key(self, key_owner=rm_const.COMMON_TOKEN_OWNER, key_name=rm_const.ARC_ACCESS_TOKEN_NAME):
            sdk2.svn.Arcadia.commit(transport_dir, user=rm_const.ROBOT_RELEASER_USER_NAME, message='Update of rearrange data')
