# coding: utf-8

from sandbox import sdk2
from sandbox.projects.resource_types import search_priemka_releasers


class SETraceResource(sdk2.Resource):
    """
    Abstract SETrace resource.
    """
    releasable = True
    any_arch = False
    releasers = search_priemka_releasers + [
        "akhruslan",
        "denis28",
        "gluk47",
        "redotter",
        "robot-srch-releaser",
        "zhigan",
    ]
    auto_backup = True


class SETraceUIBundle(SETraceResource):
    """
    Transpiled, minimized and archived files for SETrace UI.
    """

class SETraceHistory(sdk2.Resource):
    """
    Trace history json
    """
    releasable = False
    any_arch = True

class SETraceExecutable(sdk2.Resource):
    """
    Setrace binary file
    """
    releasable = False
    any_arch = True

class SETraceConfig(sdk2.Resource):
    """
    Setrace config file
    """
    releasable = False
    any_arch = True


class SETRACE_BUNDLE(SETraceResource):
    """
        Setrace project archive
    """
    releasable = True
    executable = False


class SETRACE_BUNDLE_SHARD(SETraceResource):
    """
        Not used anymore
    """
    executable = False
