# -*- coding: utf-8 -*-

import logging
import os
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.sdk2 import yav


restore_link = 'https://github.yandex-team.ru/shri-dev/backup-sandbox-task/blob/master/restore_teamcity.sh'


def render_backup_link(backup_link):
    return '''
    <div>
        <h3>
            <a href="%s?stream=tgz">Скачать артефакт с бэкапом</a>
        </h3>
        <h3>
            <a href="%s" target="_blank">Восстановление из бэкапа</a>
        </h3>
    </div>
    ''' % (backup_link, restore_link)


class BackupResource(sdk2.Resource):
    """ Backup resource """


class ShriTeamcityBackup(sdk2.Task):
    """ SHRI Teamcity server backup """

    class Parameters(sdk2.Parameters):

        deploy_unit = sdk2.parameters.String("Deploy unit", default="shri_teamcity_production.server", required=True)
        with sdk2.parameters.String("Data center", required=True) as data_center:
            data_center.values["man"] = data_center.Value("man", default=True)
            data_center.values["sas"] = "sas"
            data_center.values["iva"] = "iva"
            data_center.values["vla"] = "vla"
            data_center.values["myt"] = "iva"
        secret = sdk2.parameters.String("Secret", default="sec-01exyxpge8e4yz6264e6kkbkv0", required=True)
        artifact_ttl = sdk2.parameters.Integer("Artifact ttl", default=30, required=True)

    @sdk2.header()
    def header(self):
        return render_backup_link(self.Context.backup_link) if self.Context.backup_link else "No backup link discovered"

    def on_execute(self):
        secret = yav.Secret(self.Parameters.secret)
        oauth_token = secret.data()["DCTL_YP_TOKEN"]
        ssh_key = secret.data()["SSH_KEY"]

        resource_declaration = BackupResource(
            self, "SHRI Teamcity backup", "backup", ttl=self.Parameters.artifact_ttl
        )
        resource = sdk2.ResourceData(resource_declaration)
        resource.path.mkdir(0o755, parents=True, exist_ok=True)

        with sdk2.ssh.Key(private_part=ssh_key):
            sdk2.svn.Arcadia.export("svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/ya", '.')

            dctl = "./ya tool dctl list pod %s | sed '4q;d' | awk -F'|' '{print $3}' | xargs" % self.Parameters.deploy_unit
            env = os.environ.copy()
            env['DCTL_YP_TOKEN'] = oauth_token
            output, error = sp.Popen(dctl, shell=True, stdout=sp.PIPE, stderr=sp.PIPE, env=env).communicate()
            dctl_logger = logging.getLogger("dctl")
            dctl_logger.info('output')
            dctl_logger.info(output)
            dctl_logger.info('error')
            dctl_logger.info(error)

            APP_BACKUP_FILE = 'app_backup'
            ARTS_BACKUP_FILE = 'artifacts.tar.gz'
            TC_REMOTE_SERVER = 'root@box.%s.%s.yp-c.yandex.net' % (output.strip(), self.Parameters.data_center)

            backup_command = '''\
                $TEAMCITY_DIST/bin/maintainDB.sh backup -C -D -L -F /%s &&\
                tar -zcvf /%s $TEAMCITY_DATA_PATH/system/artifacts \
            ''' % (APP_BACKUP_FILE, ARTS_BACKUP_FILE)

            make_backup = "ssh %s '%s'" % (TC_REMOTE_SERVER, backup_command)
            copy_backup = 'scp %s:%s.zip %s.zip' % (TC_REMOTE_SERVER, APP_BACKUP_FILE, str(resource.path.joinpath(APP_BACKUP_FILE)))
            copy_artifacts = 'scp %s:%s %s' % (TC_REMOTE_SERVER, ARTS_BACKUP_FILE, str(resource.path.joinpath(ARTS_BACKUP_FILE)))
            delete_artifacts = "ssh %s 'rm /%s.zip /%s'" % (TC_REMOTE_SERVER, APP_BACKUP_FILE, ARTS_BACKUP_FILE)

            with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("remote")) as pl:
                sp.Popen(make_backup, shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()
                sp.Popen(copy_backup, shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()
                sp.Popen(copy_artifacts, shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()
                sp.Popen(delete_artifacts, shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()

        resource.ready()

        self.Context.backup_link = resource_declaration.http_proxy
        self.Context.save()

        logging.info('success')
