# coding: utf-8

import os

import sandbox.common.types.misc as ctm
from sandbox.common.types.client import Tag

import sandbox.sandboxsdk.svn as sdk_svn
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.paths as sdk_paths
import sandbox.sandboxsdk.parameters as sdk_parameters

from sandbox.projects import resource_types
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.common.build.BuildForAllTask import DoNotRemoveResourcesParameter


class CheckoutArcadiaFromURL(sdk_parameters.SandboxArcadiaUrlParameter):
    name = 'checkout_arcadia_from_url'
    description = 'SVN URL (arcadia)'
    default_value = sdk_svn.Arcadia.trunk_url() + '/infra/genisys'


class BuildGenisys(sdk_task.SandboxTask):
    type = 'BUILD_GENISYS'
    dns = ctm.DnsType.DNS64

    client_tags = Tag.GENERIC | Tag.FREEBSD | Tag.SKYNET
    input_parameters = [
        CheckoutArcadiaFromURL,
        DoNotRemoveResourcesParameter
    ]
    execution_space = 4 * 1024

    def checkout(self):
        url = self.ctx[CheckoutArcadiaFromURL.name]
        sdk_paths.make_folder('workdir', delete_content=True)
        sdk_svn.Svn.checkout(
            sdk_svn.Arcadia.svn_url(url),
            'workdir'
        )

    def on_execute(self):
        self.checkout()
        os.chdir('workdir')

        env = os.environ.copy()
        env.pop('PYTHONPATH', None)

        run_process(['./doit', '-v2', 'bundle'], log_prefix='doit', environment=env)

        self.create_resource(
            'genisys (%s)' % (self.descr, ),
            self.path('workdir/dist/genisys.tgz'),
            resource_types.GENISYS,
            arch=self.arch,
        )


__Task__ = BuildGenisys
