# coding: utf-8

from sandbox.projects import resource_types
from sandbox.projects.skynet.BuildGoSky import BuildGoSky
from sandbox.projects.common.build.BuildForAllTask import BuildForAllTask, PlatformsListParameter


class BuildGoSkyForAll(BuildForAllTask):
    type = 'BUILD_GOSKY_FOR_ALL'
    input_parameters = list(BuildGoSky.input_parameters or []) + [PlatformsListParameter]
    execution_space = 1024

    # BuildForAllTask fields
    subtask_type = BuildGoSky
    resource_type = resource_types.GOSKY_BINARY

    def get_subtask_description(self):
        return self.descr + ' for {target}'

    def get_resource_description(self):
        return 'gosky (' + self.descr + ') [{target}]'

    def on_execute(self):
        BuildForAllTask.on_execute(self)


__Task__ = BuildGoSkyForAll
