# coding: utf-8

import os
import platform

from sandbox.common.types.client import Tag

import sandbox.sandboxsdk.svn as sdk_svn
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.paths as sdk_paths
import sandbox.sandboxsdk.parameters as sdk_parameters

from sandbox.projects import resource_types
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.common.build.BuildForAllTask import VersionParameter, DoNotRemoveResourcesParameter
import sandbox.projects.common.build.ScriptBuildTask as sbt


class PythonVersion(VersionParameter):
    description = 'Python Version'
    default_value = '3.4.3'


class GCCUseSandboxGCC(sbt.UseSandboxGCCParameter):
    default_value = False


class CheckoutArcadiaFromURL(sdk_parameters.SandboxArcadiaUrlParameter):
    name = 'checkout_arcadia_from_url'
    description = 'SVN URL (arcadia)'
    default_value = sdk_svn.Arcadia.trunk_url() + '/junk/mocksoul/pystic'


class BuildPyStick(sdk_task.SandboxTask):
    type = 'BUILD_PYSTICK'
    client_tags = Tag.Group.LINUX | Tag.Group.OSX
    input_parameters = [
        CheckoutArcadiaFromURL,
        PythonVersion,
        # GCCUseSandboxGCC,
        DoNotRemoveResourcesParameter
    ]
    execution_space = 4 * 1024

    def checkout(self):
        url = self.ctx[CheckoutArcadiaFromURL.name]
        #url = sdk_svn.Arcadia.parse_url(url)
        sdk_paths.make_folder('workdir', delete_content=True)
        sdk_svn.Svn.checkout(
            sdk_svn.Arcadia.svn_url(url),
            'workdir'
        )

    def on_execute(self):
        self.checkout()
        os.chdir('workdir')

        env = os.environ.copy()
        env.pop('PYTHONPATH', None)

        for cmd, log_prefix in (
            (('/skynet/python/bin/python', '-s', '-B', '-tt', './do', 'dl'), 'do_dl'),
            (('/skynet/python/bin/python', '-s', '-B', '-tt', './do', 'all'), 'do_all'),
        ):
            run_process(cmd, log_prefix=log_prefix, environment=env)

        attrs = {
            'platform': platform.platform(),
        }

        self.create_resource(
            'pystick (%s)' % (self.descr, ),
            self.path('workdir/build/pystick.tgz'),
            resource_types.PYSTICK,
            arch=self.arch,
            attributes=attrs
        )

        self.create_resource(
            'pystick-minimal (%s)' % (self.descr, ),
            self.path('workdir/build/pystick-minimal.tgz'),
            resource_types.PYSTICK_MINIMAL,
            arch=self.arch,
            attributes=attrs
        )

        self.create_resource(
            'pysticker (%s)' % (self.descr, ),
            self.path('workdir/build/pysticker.tgz'),
            resource_types.PYSTICKER,
            arch=self.arch,
            attributes=attrs
        )


__Task__ = BuildPyStick
