# coding: utf-8

from sandbox.projects import resource_types
from sandbox.projects.skynet.BuildPyStick import BuildPyStick
from sandbox.projects.common.build.BuildForAllTask import BuildForAllTask, PlatformsListParameter


class BuildPyStickForAll(BuildForAllTask):
    type = 'BUILD_PYSTICK_FOR_ALL'
    input_parameters = list(BuildPyStick.input_parameters) + [PlatformsListParameter]
    execution_space = 512

    # BuildForAllTask fields
    subtask_type = BuildPyStick
    resource_type = resource_types.PYSTICK

    def get_subtask_description(self):
        return self.descr + ' for {target}'

    def get_resource_description(self):
        return 'pystick (' + self.descr + ') [{target}]'

    def on_execute(self):
        BuildForAllTask.on_execute(self)
        self.save_resources(resource_types.PYSTICK_MINIMAL, 'pystick-minimal (' + self.descr + ') [{target}]')
        self.save_resources(resource_types.PYSTICKER, 'pysticker (' + self.descr + ') [{target}]')


__Task__ = BuildPyStickForAll
