# -*- coding: utf-8 -*-

import logging
import os
import py
import sys


from sandbox import sdk2

from sandbox.projects.skynet import abstract_build_skycore_bundle as absb


class SkyboneCoordBundle(absb.SkycoreBundle):
    """
        TGZ bundle with skybone-coord inside and skycore service descriptor (skybone-coord.scsd)
    """
    releasers = ['mocksoul', 'zeil', 'sempav', 'max7255', 'aculage']


class BuildSkyboneCoordBundle(absb.BuildSkycoreBundle):
    """
        Build skybone-coord (skynet copier tracker (tm)) bundle.
        The result will be tgz bundle with skycore service descriptor inside.
    """
    sv_name = 'skybone-coord'
    sv_namecap = 'SkyboneCoord'
    resource_type = SkyboneCoordBundle

    Parameters = absb.make_parameters(sv_name)

    def _check_checkout(self, path):
        if not path.join('skybone-coord.scsd').check(exists=1):
            raise Exception(
                'Checkout our sources does not looks like skybone-coord sources '
                '(no skybone-coord.scsd file inside %r (contents: %r))' % (
                    str(path), path.listdir()
                )
            )

    def _build(self):
        env = os.environ.copy()
        env.pop('LD_LIBRARY_PATH', None)  # overwise, svn will not work properly
        env['PYTHON'] = sys.executable

        source_path = py.path.local(self.source_path)
        cmd = source_path.join('build.sh').strpath, 'bundle'

        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('build')) as pl:
            proc = sdk2.helpers.subprocess.Popen(
                cmd,
                stdout=pl.stdout,
                stderr=sdk2.helpers.subprocess.STDOUT,
                cwd=self.source_path.strpath,
                env=env
            )
            proc.wait()
            assert proc.returncode == 0, 'Process %r exited with code %d' % (cmd, proc.returncode)
