# -*- coding: utf-8 -*-

import logging
import os
import py
import sys


from sandbox import sdk2

from sandbox.projects.skynet import abstract_build_skycore_bundle as absb


class SkyboneMdsBundle(absb.SkycoreBundle):
    """
        TGZ bundle with skybone inside and skycore service descriptor (skybone.scsd)
    """
    releasers = ['mocksoul', 'sempav', 'zeil', 'max7255']


class BuildSkyboneMdsBundle(absb.BuildSkycoreBundle):
    """
        Build skybone (skynet copier (tm)) bundle.
        The result will be tgz bundle with skycore service descriptor inside.
    """
    sv_name = 'skybone-mds'
    sv_namecap = 'SkyboneMds'
    resource_type = SkyboneMdsBundle

    Parameters = absb.make_parameters(sv_name)

    def _check_checkout(self, path):
        if not path.join('skybone-mds.scsd').check(exists=1):
            raise Exception(
                'Checkout our sources does not looks like skybone-mds sources '
                '(no skybone-mds.scsd file inside %r (contents: %r))' % (
                    str(path), path.listdir()
                )
            )

    def _build(self):
        env = os.environ.copy()
        env.pop('LD_LIBRARY_PATH', None)  # overwise, svn will not work properly
        env['PYTHON'] = sys.executable
        env['VARIANT'] = self.sv_name

        source_path = py.path.local(self.source_path)
        cmd = source_path.join('build.sh').strpath, 'bundle'

        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('build')) as pl:
            proc = sdk2.helpers.subprocess.Popen(
                cmd,
                stdout=pl.stdout,
                stderr=sdk2.helpers.subprocess.STDOUT,
                cwd=self.source_path.strpath,
                env=env
            )
            proc.wait()
            assert proc.returncode == 0, 'Process %r exited with code %d' % (cmd, proc.returncode)
