import os

from sandbox import sdk2
from sandbox.projects.common import task_env


class SkyboneTestYtUpload(sdk2.Task):

    class Requirements(task_env.TinyRequirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        yt_upload_resource = sdk2.parameters.Resource("test-yt-upload resource")
        bstr_resource = sdk2.parameters.Resource("bstr resource")
        file_size = sdk2.parameters.Integer("File size for YT upload")
        yt_proxy = sdk2.parameters.String('YT cluster', default='hume')
        yt_path = sdk2.parameters.String('YT path for test table upload', default='//tmp/skybone-yt-test/test-table')
        yt_path_bstr = sdk2.parameters.String('YT path for bstr coordination', default='//tmp/skybone-yt-test')
        yt_secret = sdk2.parameters.YavSecret('Yav secret with YT token')

    def on_execute(self):
        yt_upload_path = str(sdk2.ResourceData(self.Parameters.yt_upload_resource).path)
        bstr_path = str(sdk2.ResourceData(self.Parameters.bstr_resource).path)
        yt_token = self.Parameters.yt_secret.data()['robot-netbeard-yt-token']

        with sdk2.helpers.ProcessLog(self, logger='yt_upload') as pl:
            pl.logger.propagate = 1
            ret = sdk2.helpers.subprocess.Popen(
                [yt_upload_path,
                 '--proxy', self.Parameters.yt_proxy,
                 '--path', self.Parameters.yt_path,
                 '--file-size', str(self.Parameters.file_size)
                ],
                stdout=pl.stdout,
                stderr=sdk2.helpers.subprocess.STDOUT,
                env={'YT_TOKEN': yt_token}
            ).wait()
            assert ret == 0, '{} exited with code {}'.format(yt_upload_path, ret)

        with sdk2.helpers.ProcessLog(self, logger='bstr_push') as pl:
            pl.logger.propagate = 1
            ret = sdk2.helpers.subprocess.Popen(
                [bstr_path,
                 'push',
                 '-v',
                 '--proxy', self.Parameters.yt_proxy,
                 '--cypress-dir', self.Parameters.yt_path_bstr,
                 '--file', self.Parameters.yt_proxy + ':' + self.Parameters.yt_path
                ],
                stdout=pl.stdout,
                stderr=sdk2.helpers.subprocess.STDOUT,
                env={'YT_TOKEN': yt_token}
            ).wait()
            assert ret == 0, '{} exited with code {}'.format(bstr_path, ret)
