# coding: utf8
from sandbox import sdk2

__all__ = [
    'SmarttvReportDockerImage',
    'SmarttvDroidekaDockerImage',
    'SmarttvReportPackage',
    'SmarttvDroidekaPackage',
    'SmarttvUpdaterPackage',
    'SmarttvUpdaterGatewayPackage',
    'SmarttvAliceProxyPackage',
    'SmarttvOntoIdMapping',
]


class SmarttvDockerImageBase(sdk2.Resource):
    releasable = True
    executable = False
    releasers = ['SMARTTV', 'robot-testenv', 'robot-srch-releaser']


class SmarttvReportDockerImage(SmarttvDockerImageBase):
    pass


class SmarttvDroidekaDockerImage(SmarttvDockerImageBase):
    pass


class SmarttvReportPackage(SmarttvDockerImageBase):
    pass


class SmarttvDroidekaPackage(SmarttvDockerImageBase):
    pass


class SmarttvUpdaterPackage(SmarttvDockerImageBase):
    pass


class SmarttvUpdaterGatewayPackage(SmarttvDockerImageBase):
    pass


class SmarttvAliceProxyPackage(SmarttvDockerImageBase):
    pass


class SmarttvOntoIdMapping(sdk2.Resource):
    releasable = True
    executable = False
    any_arch = False
    calc_md5 = True
    releasers = ['SMARTTV']


class SmarttvContentTypeMapping(sdk2.Resource):
    releasable = True
    executable = False
    any_arch = False
    calc_md5 = True
    releasers = ['SMARTTV']
