# coding: utf-8

import sandbox.projects.sortdc.resources as sortdc_resources

from sandbox import sdk2
from sandbox.sandboxsdk import parameters
from sandbox.projects.sortdc.common.base_bin_build import BaseBuildSortDCBins
from sandbox.projects.sortdc.common.base_bin_build import SortDCBinaries
from sandbox.projects.sortdc.common.base_bin_build import init


class BuildSortDCPackage(BaseBuildSortDCBins):
    '''
    Binaries, configs and scripts for sortdc.
    '''

    type = 'BUILD_SORTDC_PACKAGE'

    class Requirements(sdk2.Task.Requirements):
        disk_space = 70 * 1024

    class IncludeSvnConfigs(parameters.SandboxBoolParameter):
        name = 'include_svn_configs'
        description = 'configs'
        default_value = True
        group = 'SortDC Files'

    class IncludeSvnScripts(parameters.SandboxBoolParameter):
        name = 'include_svn_scripts'
        description = 'scripts'
        default_value = True
        group = 'SortDC Files'

    TARGET_RESOURCES = (
        sortdc_resources.SORTDC_LB_READER,
        sortdc_resources.SORTDC_LB_WRITER,
        sortdc_resources.SORTDC_URL_UPDATES_PROCESSOR,
        sortdc_resources.SORTDC_EXPORT_UPDATES_PROCESSOR,
        sortdc_resources.SORTDC_CREATE_INSTANCE,
        sortdc_resources.SORTDC_DIRECT_DATA,
        sortdc_resources.SORTDC_BATCH_EXPORTER,
        sortdc_resources.SORTDC_FEED_UPDATES_PROCESSOR,
        sortdc_resources.SORTDC_VIEWER,
        sortdc_resources.SORTDC_ZLOG_PROCESSOR,
        sortdc_resources.SORTDC_DATACAMP_READER,
        sortdc_resources.SORTDC_REPLICATION_TOOL,
        sortdc_resources.SORTDC_COUNTERS_TOOL,
        sortdc_resources.SORTDC_FEED_REMOVER,
        sortdc_resources.SORTDC_SOLOMON_AGENT,
        sortdc_resources.SORTDC_EXPORTED_STATE_TOOL,
    )

    input_parameters, enabled_builds = init(TARGET_RESOURCES, [SortDCBinaries])
    input_parameters = input_parameters + [IncludeSvnConfigs,
                                           IncludeSvnScripts]

    def on_execute(self):
        BaseBuildSortDCBins.on_execute(self)

    def post_build(self, source_dir, output_dir, pack_dir):
        BaseBuildSortDCBins.post_build(self, source_dir, output_dir, pack_dir)
        if self.ctx['include_svn_configs']:
            self._create_svn_resource('robot/sortdc/conf', 'svn_configs.tar.gz', sortdc_resources.SORTDC_SVN_CONFIGS, source_dir)
        if self.ctx['include_svn_scripts']:
            self._create_svn_resource('robot/sortdc/scripts', 'scripts.tar.gz', sortdc_resources.SORTDC_SVN_SCRIPTS, source_dir)

__Task__ = BuildSortDCPackage
