# coding: utf-8

from sandbox.sdk2.resource import AbstractResource
from sandbox.projects.resource_types import releasers as resource_releasers

sortdc_releasers = resource_releasers.samovar_releasers + ['andreytert']


# base classes
class SORTDC_SYMBOLS_ARCHIVE(AbstractResource):
    """
        Symbols from sortcd binaries
    """
    releasable = True
    executable = False
    any_arch = False
    releasers = sortdc_releasers


class SORTDC_BINARY(AbstractResource):
    """
        Base class for binary files used in SortDC Project.
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = sortdc_releasers


# sortdc

class SORTDC_LB_READER(SORTDC_BINARY):
    arcadia_build_path = 'robot/sortdc/lb_reader/server/lb_reader'


class SORTDC_LB_WRITER(SORTDC_BINARY):
    arcadia_build_path = 'robot/sortdc/lb_writer/server/lb_writer'


class SORTDC_URL_UPDATES_PROCESSOR(SORTDC_BINARY):
    arcadia_build_path = 'robot/sortdc/url_updates_processor/server/url_updates_processor'


class SORTDC_EXPORT_UPDATES_PROCESSOR(SORTDC_BINARY):
    arcadia_build_path = 'robot/sortdc/export_updates_processor/server/export_updates_processor'


class SORTDC_CREATE_INSTANCE(SORTDC_BINARY):
    arcadia_build_path = 'robot/sortdc/tools/create_instance/create_instance'


class SORTDC_DIRECT_DATA(SORTDC_BINARY):
    arcadia_build_path = 'robot/sortdc/tools/direct_data/direct_data'


class SORTDC_BATCH_EXPORTER(SORTDC_BINARY):
    arcadia_build_path = 'robot/sortdc/tools/batch_exporter/batch_exporter'


class SORTDC_FEED_UPDATES_PROCESSOR(SORTDC_BINARY):
    arcadia_build_path = 'robot/sortdc/feed_updates_processor/server/feed_updates_processor'


class SORTDC_VIEWER(SORTDC_BINARY):
    arcadia_build_path = 'robot/sortdc/viewer/viewer'


class SORTDC_ZLOG_PROCESSOR(SORTDC_BINARY):
    arcadia_build_path = 'robot/tools/zlog_processor/zlog_processor'


class SORTDC_DATACAMP_READER(SORTDC_BINARY):
    arcadia_build_path = 'robot/sortdc/tools/datacamp_reader/datacamp_reader'


class SORTDC_REPLICATION_TOOL(SORTDC_BINARY):
    arcadia_build_path = 'robot/sortdc/tools/replication_tool/replication_tool'


class SORTDC_COUNTERS_TOOL(SORTDC_BINARY):
    arcadia_build_path = 'robot/sortdc/tools/counters_tool/counters_tool'


class SORTDC_FEED_REMOVER(SORTDC_BINARY):
    arcadia_build_path = 'robot/sortdc/tools/feed_remover/feed_remover'


class SORTDC_SOLOMON_AGENT(SORTDC_BINARY):
    arcadia_build_path = 'robot/tools/solomon_agent/solomon_agent'


class SORTDC_EXPORTED_STATE_TOOL(SORTDC_BINARY):
    arcadia_build_path = 'robot/sortdc/tools/exported_state_tool/exported_state_tool'


class SORTDC_SVN_CONFIGS(AbstractResource):
    """
        Class for SortDC configs from svn
    """
    releasable = True
    executable = False
    releasers = sortdc_releasers


class SORTDC_SVN_SCRIPTS(SORTDC_SVN_CONFIGS):
    """
        Class for SortDC scripts from svn
    """
    pass
