# -*- coding: utf-8 -*-
from sandbox import sdk2


SPI_TOOLS_RELEASERS = [
    'lebedev-aa',
    'pufit',
    'cdraugr',
    'vangr',
    'ziyatov',
    'mgolosova',

    'robot-beholder',
    'robot-testenv',
    'robot-srch-releaser',
    'robot-yappy',
    'robot-tickenator',
]


class TickenatorBinary(sdk2.Resource):
    """
    Tickenator binary.
    """
    releasable = True
    any_arch = False
    releasers = SPI_TOOLS_RELEASERS
    auto_backup = True
    arcadia_build_path = 'search/mon/tickenator_on_db/bin/tickenator'


class BeholderBinary(sdk2.Resource):
    """
    Beholder binary.
    """

    releasable = True
    any_arch = False
    releasers = SPI_TOOLS_RELEASERS
    auto_backup = True
    arcadia_build_path = 'search/beholder/bin/beholder'


class BeholderControllerBinary(sdk2.Resource):
    """
    Beholder binary prestable
    """

    releasable = True
    any_arch = False
    releasers = SPI_TOOLS_RELEASERS
    auto_backup = True
    arcadia_build_path = 'search/beholder/bin/beholder'
