# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.common.build import YaMake2
from sandbox.projects.common.ya_deploy import release_integration

from sandbox.projects.sport import resource_types


class BuildSportApiServant(release_integration.ReleaseToYaDeployTask2, YaMakeTemplate.YaMakeTemplate):
    """Build Sport Apphost servant"""

    class Parameters(YaMakeTemplate.get_project_params([resource_types.SPORT_API_SERVANT_EXECUTABLE])):
        pass

    class Context(sdk2.Context):
        yp_token_vault = 'robot-ynews-yp_token'

    def on_release(self, additional_parameters):
        release_integration.ReleaseToYaDeployTask2.on_release(self, additional_parameters)
        YaMake2.YaMake2.on_release(self, additional_parameters)
