# -*- coding: utf-8 -*-
from sandbox.sdk2.resource import AbstractResource

from sandbox.projects.sport import resource_types
from sandbox.projects.sport.BuildSportServiceConfigBundleBase import BuildSportServiceConfigBundleBase


class SPORT_ROUTERD_TEMPLATES_CONFIG(AbstractResource):
    """"""
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.sport_releasers


class SPORT_ROUTERD_DYNAMIC_ROBOTS_TXT_CONFIG(AbstractResource):
    """"""
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.sport_releasers


class SPORT_ROUTERD_RUN_TEMPLATE(AbstractResource):
    """"""
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.sport_releasers


class SPORT_ROUTERD_LEGACY_BROWSERS_CONFIG(AbstractResource):
    """"""
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.sport_releasers


class BuildSportAppHostRouterdServiceConfigBundle(BuildSportServiceConfigBundleBase):
    """Build bundle with config files and scripts for Nanny service of sport app_host routerd"""

    type = "BUILD_SPORT_APPHOST_ROUTERD_SERVICE_CONFIG_BUNDLE"

    NEWS_CONFIG_RESOURCES = {
        "instancectl.conf": resource_types.SPORT_APPHOST_ROUTERD_INSTANCECTL_CONF,
        "templates_config": SPORT_ROUTERD_TEMPLATES_CONFIG,
        "dynamic_robots_txt.json": SPORT_ROUTERD_DYNAMIC_ROBOTS_TXT_CONFIG,
        "run_template.sh": SPORT_ROUTERD_RUN_TEMPLATE,
        "legacy_browsers.json": SPORT_ROUTERD_LEGACY_BROWSERS_CONFIG
    }


__Task__ = BuildSportAppHostRouterdServiceConfigBundle
