# -*- coding: utf-8 -*-

import json
import os
import logging
import tempfile

from sandbox import sdk2
from sandbox.sandboxsdk.paths import copy_path
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.projects.sport.resources import SPORT_NEWS_RECOMMENDER_MODELS_PACKAGE, SPORT_NEWS_RECOMMENDER_MODEL

from sandbox.projects.common.nanny import nanny


class BuildSportRecommenderResourcePackage(nanny.ReleaseToNannyTask2, sdk2.Task):
    '''
        create a directory with recommender's resources
    '''

    class Parameters(sdk2.Task.Parameters):
        arranged_config = sdk2.parameters.String('Path to arranged_data.conf', required=False,
                                                 default="svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/sport/news/config/services/app_host/arranged/arranged_data.conf")
        release_type = sdk2.parameters.String('Release type', required=False, default="stable")

    def on_execute(self):
        directory = "models"
        os.makedirs(directory)

        arranged_config_file = tempfile.mkstemp()[1]
        Arcadia.export(self.Parameters.arranged_config, arranged_config_file)

        with open(arranged_config_file) as f:
            arranged_config = json.loads(f.read())
            for item in arranged_config["recommender_models"]:
                name = item["name"]
                logging.info("Trying to get " + name + " resource")
                attrs = {"name": name, "released": self.Parameters.release_type}
                resource = sdk2.Resource.find(
                    SPORT_NEWS_RECOMMENDER_MODEL,
                    attrs=attrs).order(-sdk2.Resource.id).first()
                if not resource:
                    raise ValueError("No resources with attrs: " + str(attrs))
                resource_path = str(sdk2.ResourceData(resource).path)
                basename = os.path.basename(resource_path)
                copy_path(resource_path, os.path.join(directory, basename))
                logging.info(name + " is OK")

        result = SPORT_NEWS_RECOMMENDER_MODELS_PACKAGE(self, "Bundle of resources", directory)
        sdk2.ResourceData(result)
