# -*- coding: utf-8 -*-

from sandbox.projects.sport import resources

from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.copy import RemoteCopy
from sandbox import sdk2

FILES = {
    "persistent_flags.yaml": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/sport/news/config/services/app_host/routerd/persistent_flags.yaml"
}


class BuildSportRouterdPersistentFlags(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
        Get persistnet_flags.yaml
    """

    class Parameters(sdk2.Task.Parameters):
        svn_revision = sdk2.parameters.Integer("SVN revision", required=True)

    def download_file(self, src, dst):
        RemoteCopy(src, dst,
                   log_dir=self.log_path())(timeout=RemoteCopy.DEFAULT_TIMEOUT)

    def on_execute(self):
        for filename, src_path in FILES.iteritems():
            self.download_file(src_path + "@" + str(self.Parameters.svn_revision), filename)

        persistent_flags = sdk2.ResourceData(resources.SPORT_ROUTERD_PERSISTENT_FLAGS(self, "persistent_flags.yaml", "persistent_flags.yaml", ttl=28))
        persistent_flags.ready()
