# -*- coding: utf-8

import os
from sandbox.projects.common import constants
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.nanny import nanny
import sandbox.projects.common.build.parameters as build_params
import sandbox.sandboxsdk.parameters as sb_params


class ServiceConfigPath(sb_params.SandboxStringParameter):
    name = 'service_config_path'
    description = 'Path to the service config directory'
    required = True
    group = 'Path'
    default_value = 'sport/news/config/services/[SERVICE]'


class OutputConfigArtifacts(sb_params.DictRepeater, sb_params.SandboxStringParameter):
    name = 'output_config_artifacts'
    description = 'Configuration file (type -> name)'
    required = True
    group = 'Path'


class BuildSportServiceConfigBundleBase2(nanny.ReleaseToNannyTask, YaMakeTask):
    """Build bundle with config files and scripts for Y.News' abstract Nanny service"""

    type = "BUILD_SPORT_SERVICE_CONFIG_BUNDLE_BASE_2"

    NEWS_CONFIG_RESOURCES = {}
    NEWS_SERVICE_CONFIG_PATH = None

    base_input_parameters = [
        build_params.ArcadiaUrl,
        build_params.ArcadiaPatch,
        build_params.UseArcadiaApiFuse,
        build_params.UseArcInsteadOfArcadiaApi,
        build_params.AllowArcadiaApiFallback,
        build_params.BuildSystem,
        build_params.BuildType,
        build_params.TestParameter,
    ]

    input_parameters = base_input_parameters + [ServiceConfigPath, OutputConfigArtifacts]

    def initCtx(self):
        YaMakeTask.initCtx(self)

        if self.NEWS_SERVICE_CONFIG_PATH:
            self.ctx[ServiceConfigPath.name] = self.NEWS_SERVICE_CONFIG_PATH

        self.ctx[OutputConfigArtifacts.name] = {}
        for filename, resource_type in self.NEWS_CONFIG_RESOURCES.iteritems():
            self.ctx[OutputConfigArtifacts.name].setdefault(str(resource_type), filename)

        self.ctx[build_params.AllowArcadiaApiFallback.name] = True
        self.ctx[build_params.UseArcadiaApiFuse.name] = True
        self.ctx[build_params.UseArcInsteadOfArcadiaApi.name] = True
        self.on_save()

    def on_save(self):
        self.ctx[build_params.CheckoutParameter.name] = True
        self.ctx[build_params.CheckoutModeParameter.name] = constants.CHECKOUT_MODE_AUTO

    def on_enqueue(self):
        YaMakeTask.on_enqueue(self)

    def get_targets(self):
        return [self.ctx[ServiceConfigPath.name]]

    def get_resources(self):
        resources = {}
        target, = self.get_targets()
        for resource_type, filename in self.ctx[OutputConfigArtifacts.name].items():
            result = {
                'resource_type': resource_type,
                'resource_path': filename,
                'description': 'Infrastructure file {} for Nanny service'.format(filename),
            }
            resources[resource_type] = result

        return resources

    def get_arts(self):
        result = []
        target, = self.get_targets()
        for resource_type, filename in self.ctx[OutputConfigArtifacts.name].items():
            result.append({
                'path': os.path.join(target, filename),
            })
        return result
