# -*- coding: utf-8 -*-

from sandbox.projects.sport import resources

from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.copy import RemoteCopy
from sandbox import sdk2


class BuildSportSportNewsDataConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
        Gather sport_news_data.json config for sport NewsDataAAS
    """

    class Parameters(sdk2.Task.Parameters):
        svn_revision = sdk2.parameters.Integer("SVN revision", required=True)

    def download_file(self, src, dst):
        RemoteCopy(src, dst,
                   log_dir=self.log_path())(timeout=RemoteCopy.DEFAULT_TIMEOUT)

    def on_execute(self):
        self.download_file("svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/sport/news/config/services/app_host/news_data_aas/sport_news_data.json@" + str(self.Parameters.svn_revision),
                           "sport_news_data.json")

        sportNewsDataResource = sdk2.ResourceData(resources.SPORT_SPORT_NEWS_DATA_CONF(self, "sport_news_data config", "sport_news_data.json", ttl=28))
        sportNewsDataResource.ready()
