from sandbox import sdk2
from sandbox.projects.sport.resource_types import SPORT_PARTNERS_DATA_CACHE

from .cacher import cache_data


class SportCachePartnersDataTask(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        max_restarts = 1
        kill_timeout = 10 * 60

        infostrada_secret = sdk2.parameters.YavSecret(
            'Infostrada credentials [login, password]', required=True,
            default='sec-01epejbnpkrj194hwp09t6shm9'
        )

    def on_execute(self):
        partners_cache_data = cache_data(self)

        for project, stream in partners_cache_data.items():
            resource = SPORT_PARTNERS_DATA_CACHE(
                task=self,
                description="Sport partners data cache [%s]" % (project, ),
                path=project  # project folder
            )
            resource.project = project

            data = sdk2.ResourceData(resource)
            data.path.mkdir(0o755, parents=True, exist_ok=True)
            data.path.joinpath("partners_data_cache.json").write_bytes(stream.read())
            data.ready()
