# -*- coding: utf-8 -*-
import os

from sandbox.projects.sport.resource_types import SPORT_POSTGRESQL_DUMP
from sandbox.projects.sandbox.resources import LXC_CONTAINER
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp


class DumpSportApiPostgreSql(sdk2.Task):
    """
    Таск для дампа PostgreSQL базы бекенда СпортАпи
    """
    class Parameters(sdk2.Task.Parameters):
        max_restarts = 1
        kill_timeout = 1 * 3600

        hosts = sdk2.parameters.String('List of PostgreSQL hosts',
                                       default='sas-r0hme8mxc8ke15el.db.yandex.net,vla-kj4246s5pfrur0vh.db.yandex.net,man-03y5aq27l6gdh1qt.db.yandex.net',
                                       required=True)
        database = sdk2.parameters.String('Database name to dump',
                                          default='sport',
                                          required=True)
        port = sdk2.parameters.Integer('Database port',
                                       default=6432,
                                       required=True)
        user = sdk2.parameters.String('Database username',
                                      default='sport',
                                      required=True)
        vault_key = sdk2.parameters.String('Vault key with password from DB',
                                           default='SPORT_API_PG_PASSWORD',
                                           required=True)
        _container = sdk2.parameters.Container('Environment container resource',
                                               default_value=1463229735,
                                               resource_type=LXC_CONTAINER,
                                               required=True)

    def on_execute(self):
        connection_string = 'host=%s port=%s dbname=%s user=%s sslmode=require target_session_attrs=any' % (
            self.Parameters.hosts,
            self.Parameters.port,
            self.Parameters.database,
            self.Parameters.user,
        )
        filename = "dump.sql"
        if os.path.exists(filename):
            os.remove(filename)
        cmd = [
            'pg_dump',
            connection_string,
            '--oids',
            '--clean',
            '-f', filename,
        ]
        env = {
            'PGPASSWORD': sdk2.Vault.data(self.owner, self.Parameters.vault_key),
        }
        with sdk2.helpers.ProcessLog(self, logger="pg_dump") as pl:
            sp.check_call(cmd, stderr=pl.stderr, stdout=pl.stdout, env=env)
            SPORT_POSTGRESQL_DUMP(self, "SportApi PostgreSQL base dump", filename)
