# -*- coding: utf-8 -*-

from .checker import check_and_alert

from datetime import datetime, timedelta

from sandbox import sdk2

translation_ru = 'ru'
translation_en = 'en'


class SportApiChecker(sdk2.Task):
    """
    Таск для автоматических проверок данных в Спорт Апи за последние 30 суток
    """
    class Parameters(sdk2.Task.Parameters):
        max_restarts = 1
        kill_timeout = 1 * 3600

        projects = sdk2.parameters.String('List of projects to check',
                                          default='football,hockey,basketball,volleyball,time_judge',
                                          required=True)

        recipients = sdk2.parameters.String('List of email addresses to receive the report',
                                            default=None,
                                            required=True)

    def on_execute(self):
        format = "%Y-%m-%d"
        today = datetime.now()
        ago = today - timedelta(days=30)
        from_ = ago.strftime(format)
        to = today.strftime(format)

        projects = [s.strip() for s in self.Parameters.projects.split(',')]

        recipients = [s.strip() for s in self.Parameters.recipients.split(',')]
        recipients = [r + '@yandex-team.ru' if '@' not in r else r for r in recipients]

        check_and_alert(projects, from_, to, recipients)
