import requests
from requests.adapters import HTTPAdapter


class Client(object):
    def __init__(self, api_url, headers=None, retry_cnt=0):
        self._api_url = api_url
        self._headers = headers or {}
        self._retry_cnt = retry_cnt
        self._session = requests.Session()
        self._session.mount(self._api_url, HTTPAdapter(max_retries=self._retry_cnt))

    def request(self, uri, headers=None):
        result = self._session.request("get", self._api_url + uri, headers=self._get_headers(headers))
        if not result.ok:
            return Result("{}: {}".format(result.status_code, result.content), result.headers)

        try:
            json_result = result.json()
        except Exception as e:
            return Result("JSON decode error: {}\n{}".format(e.message, result.content), result.headers)

        return Result(json_result, result.headers)

    def _get_headers(self, headers):
        merged_headers = self._headers.copy()
        merged_headers.update(headers or {})
        return merged_headers


class Result(object):
    def __init__(self, data, headers):
        self.data = data
        self.headers = headers


EMPTY_RESULT = Result(None, None)
