def parse_log_line(i_logs):
    for line in i_logs:
        buf = ""
        result = []
        can_flush = True
        for char in line:
            if (char == " " or char == "\n") and can_flush:
                result.append(buf)
                buf = ""
                continue

            if can_flush:
                if char == "[" or char == "\"":
                    can_flush = False
                    continue
            else:
                if char == "]" or char == "\"":
                    can_flush = True
                    continue

            buf += char

        yield result


def get_uri_from_parsed(i_parsed):
    for row in i_parsed:
        req = row[3]
        req_parts = req.split(" ")
        if len(req_parts) != 3:
            continue
        yield req_parts[1]
