# -*- coding: utf-8 -*-
import os
import logging
import shutil

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess


logger = logging.getLogger('update_tables_logger')


class SportArchiveUpdateTables(sdk2.Task):
    class Parameters(sdk2.Parameters):
        owner = 'SPORT'
        tags = ['SPORT-ARCHIVES', 'SPORT']
        max_restarts = 1

        with sdk2.parameters.Group('Config') as config:
            resource = sdk2.parameters.Resource(
                'Arcadia Resource',
                default_value=1904679603,
                required=True,
            )

        with sdk2.parameters.Group('YT') as yt:
            with sdk2.parameters.RadioGroup('YT cluster') as cluster:
                cluster.values['arnold'] = cluster.Value("arnold", default=True)
                cluster.values['hahn'] = cluster.Value("hahn")
            source = sdk2.parameters.String(
                'Source YT table',
                default_value='//home/sport/dynstorage/info-russian/data',
                required=True,
            )
            target = sdk2.parameters.String(
                'Target YT table',
                default_value='//home/sport/storage/info/entries',
                required=True,
            )

        with sdk2.parameters.Group('Environments') as env:
            yt_env = sdk2.parameters.Dict(
                'YT environment',
                default={
                    'YT_POOL': 'sport',
                    'YT_LOG_LEVEL': 'DEBUG',
                },
                required=True,
            )
            yt_token = sdk2.parameters.YavSecretWithKey(
                'YT token',
                default_value='sec-01cpt5v1fddttqtcxwakkshvt3#YT_TOKEN',
                required=True,
            )

    def on_execute(self):
        os.environ.update(self.Parameters.yt_env)
        os.environ.update(dict(YT_TOKEN=self.Parameters.yt_token.value()))

        logger.info('env: \n\r %s' % str(os.environ))

        resource_data = sdk2.ResourceData(self.Parameters.resource)
        resource_name = self.Parameters.resource.description

        resource_binary_original_path = str(resource_data.path)
        resource_binary_new_path = str(self.path(resource_name))

        shutil.copy(resource_binary_original_path, resource_binary_new_path)
        os.chmod(resource_binary_new_path, 0o777)

        with sdk2.helpers.ProcessLog(self, logger=logger) as pl:
            subprocess.check_call(
                [
                    resource_binary_new_path,
                    '--yt-proxy',
                    self.Parameters.cluster,
                    '--source',
                    self.Parameters.source,
                    '--target',
                    self.Parameters.target,
                ],
                stdout=pl.stdout,
                stderr=pl.stderr,
            )
