# -*- coding: utf-8 -*-
from sandbox.sdk2.resource import Resource
from sandbox.projects.sandbox.resources import LXC_CONTAINER
from sandbox import sdk2


AbstractResource = sdk2.resource.AbstractResource

sport_releasers = [
    'stupidhobbit',
    'dm-fish',
    'zvr-s',
    'gsat83',
    'robot-ynews-releaser',
    'dim-ch',
]


class SPORT_EXECUTABLE(Resource):
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_ADMIN_EXECUTABLE(SPORT_EXECUTABLE):
    arcadia_build_path = 'sport/backend/admin'


class SPORT_NEW_ADMIN_API_EXECUTABLE(SPORT_EXECUTABLE):
    arcadia_build_path = 'sport/new_backend/admin/api/bin'


class SPORT_NEW_BACKEND_CELERY_EXECUTABLE(SPORT_EXECUTABLE):
    arcadia_build_path = 'sport/new_backend/data_processing/celery/bin'


class SPORT_NEW_BACKEND_ALEMBIC_EXECUTABLE(SPORT_EXECUTABLE):
    arcadia_build_path = 'sport/new_backend/alembic/bin'


class SPORT_NEW_ADMIN_NGINX_CONFIG(Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers
    arcadia_build_path = 'sport/new_backend/admin/nginx'


class SPORT_NEW_ADMIN_FRONT_BUILD(Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers
    arcadia_build_path = 'sport/new_backend/admin/ui'


class SPORT_MANAGE_EXECUTABLE(SPORT_EXECUTABLE):
    arcadia_build_path = 'sport/backend/manage'


class SPORT_IMPORTERS_EXECUTABLE(SPORT_EXECUTABLE):
    arcadia_build_path = 'sport/backend/importers'


class SPORT_API_SERVANT_EXECUTABLE(SPORT_EXECUTABLE):
    arcadia_build_path = 'sport/api/app/bin/sport-api-servant'


class SPORT_LXC_IMAGE(LXC_CONTAINER):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = sport_releasers


class SPORT_NODE_API_SERVANT_PACKAGE(Resource):
    """
    deb пакет сo спортивным апи
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_POSTGRESQL_DUMP(Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_PARTNERS_DATA_CACHE(Resource):
    auto_backup = True

    project = sdk2.parameters.String("Sport project")


class SPORT_PARTNERS_DATA_CACHE_DIFF(Resource):
    auto_backup = True


class SPORT_API_DIFF_LOGS(Resource):
    executable = False
    releasable = True
    releasers = sport_releasers


class SPORT_DASHBOARD_FRONT_BUILD(Resource):
    executable = False
    releasable = True
    releasers = sport_releasers
    arcadia_build_path = 'sport/backend/dashboard/ui'


class SPORT_SLAVE_NEWSD_CONF(AbstractResource):
    """
        Конфиг для slave_newsd
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = sport_releasers


class SPORT_SLAVE_NEWSD_INSTANCECTL_CONF(AbstractResource):
    """
        Конфиг instancectl для инстанса slave_newsd
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = sport_releasers


class SPORT_SLAVE_NEWSD_RUNNER(AbstractResource):
    """
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = sport_releasers


class SPORT_APPHOST_ROUTERD_INSTANCECTL_CONF(AbstractResource):
    """
        Конфиг instancectl для инстанса app_host_routerd
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = sport_releasers


class SPORT_UATRAITS_BROWSER_XML(AbstractResource):
    """
    """
    auto_backup = True
    releasable = True
    releasers = sport_releasers
