# coding: utf-8
from sandbox import sdk2

sport_releasers = [
    'robot-srch-releaser',
    'robot-testenv',
    'stupidhobbit',
    'dm-fish',
    'gsat83',
    'zvr-s',
]


class SPORT_DEFAULT_INDEX_CONFIG(sdk2.Resource):
    """
        default index config for slave_newsd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_SLAVE_NEWSD_DATA_CONF(sdk2.Resource):
    """
        data config for slave_newsd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_SLAVE_NEWSD_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for slave_newsd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_UATRAITS_PROFILES_XML(sdk2.Resource):
    """
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_UATRAITS_EXTRA_XML(sdk2.Resource):
    """
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_ROUTERD_PERSISTENT_FLAGS(sdk2.resource.AbstractResource):
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_ROUTERD_PARAMS_PRESETS(sdk2.Resource):
    """
        params_presets.json
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_APPHOST_AUTHD_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for authd
    """
    executable = False
    releaseable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_AUTHD_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for authd
    """
    executable = False
    releaseable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_APPHOST_NEWS_PROXY_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for NEWS_PROXY
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_NEWS_PROXY_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for news_proxy
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_PROXY_SURVEYS_CONFIGS(sdk2.Resource):
    """
        surveys_configs.json
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_APPHOST_NEW_RUNTIME_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for NEW_RUNTIME
    """
    executable = False
    releaseable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_NEW_RUNTIME_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for new_runtime
    """
    executable = False
    releaseable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_APPHOST_NEWS_DATA_AAS_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for authd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_NEWS_DATA_AAS_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for news_data_aas
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_SPORT_NEWS_DATA_CONF(sdk2.Resource):
    """
        sport_news_data.json config
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_SPORT_VIDEO_CAROUSELS(sdk2.Resource):
    """
        vh sport video carousels
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_SPORT_SETUP_CONF(sdk2.Resource):
    """
        sport_news_data.json config
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_ADDITIONAL_RUBRICS_CONF(sdk2.Resource):
    """
        additional_rubrics.json
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_APPHOST_SPORT_BLENDER_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for authd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_SPORT_BLENDER_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for sport_blender
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_APPHOST_ARRANGED_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for arranged
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_RECOMMENDER_SYSTEM_CONFIG(sdk2.Resource):
    """
        config for personalization in slave_newsd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_APPHOST_ARRANGED_DATA_SERVER_CONF(sdk2.Resource):
    """
        config for state server in arranged
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_APPHOST_ARRANGED_DATA_CONF(sdk2.Resource):
    """
        config for data resources in arranged
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_APPHOST_ARRANGED_DEFAULT_FLAGS(sdk2.Resource):
    """
        config for default flags in arranged
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_ARRANGED_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for arranged
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers


class SPORT_NEWS_RECOMMENDER_MODELS_PACKAGE(sdk2.Resource):
    """
        all models for recommender
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_NEWS_RECOMMENDER_MODEL(sdk2.Resource):
    """
        models for personalization
    """
    __default_attribute__ = sdk2.parameters.String

    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_APPHOST_API_RESPONDER_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for api_responder
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_releasers


class SPORT_API_RESPONDER_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for api_responder
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = sport_releasers
